/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.v1_8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawner;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.particle.ParticleSpawnerFactory;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SpigotParticleSpawnerFactory_v1_8
implements ParticleSpawnerFactory {
    private final MethodHandle playEffect;
    private final Effect effect;

    public SpigotParticleSpawnerFactory_v1_8() throws Throwable {
        Class<?> spigotType = Class.forName("org.bukkit.entity.Player$Spigot");
        this.playEffect = MethodHandles.publicLookup().findVirtual(spigotType, "playEffect", MethodType.methodType(Void.TYPE, Location.class, Effect.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE));
        this.effect = Effect.valueOf((String)"COLOURED_DUST");
    }

    @Override
    @NotNull
    public ParticleSpawner createSpawner(@NotNull Player player) {
        return new Spawner(player);
    }

    private class Spawner
    implements ParticleSpawner {
        private final Player player;

        private Spawner(Player player) {
            this.player = player;
        }

        @Override
        public void spawnParticle(Vector3dc position, GizmoColor color, double size) {
            Color bukkitColor = Color.fromRGB((int)color.asRGB());
            try {
                SpigotParticleSpawnerFactory_v1_8.this.playEffect.invoke(this.player.spigot(), new Location(this.player.getWorld(), position.x(), position.y(), position.z()), SpigotParticleSpawnerFactory_v1_8.this.effect, 0, 1, Math.max((float)bukkitColor.getRed() / 255.0f, Float.MIN_VALUE), (float)bukkitColor.getGreen() / 255.0f, (float)bukkitColor.getBlue() / 255.0f, 1, 0, 64);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public double getDensity(double size) {
            return 3.0;
        }
    }
}

