/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.api;

import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;

public enum GizmoAxis {
    X(new Vector3d(1.0, 0.0, 0.0)){

        @Override
        @NotNull
        public GizmoAxis next() {
            return Y;
        }

        @Override
        public double getValue(@NotNull Vector3dc vector) {
            return vector.x();
        }

        @Override
        public void setValue(@NotNull Vector3d vector, double value) {
            vector.x = value;
        }
    }
    ,
    Y(new Vector3d(0.0, 1.0, 0.0)){

        @Override
        @NotNull
        public GizmoAxis next() {
            return Z;
        }

        @Override
        public double getValue(@NotNull Vector3dc vector) {
            return vector.y();
        }

        @Override
        public void setValue(@NotNull Vector3d vector, double value) {
            vector.y = value;
        }
    }
    ,
    Z(new Vector3d(0.0, 0.0, 1.0)){

        @Override
        @NotNull
        public GizmoAxis next() {
            return X;
        }

        @Override
        public double getValue(@NotNull Vector3dc vector) {
            return vector.z();
        }

        @Override
        public void setValue(@NotNull Vector3d vector, double value) {
            vector.z = value;
        }
    };

    private final Vector3dc direction;

    private GizmoAxis(Vector3dc direction) {
        this.direction = direction;
    }

    @NotNull
    public Vector3dc direction() {
        return this.direction;
    }

    @NotNull
    public abstract GizmoAxis next();

    public abstract double getValue(@NotNull Vector3dc var1);

    public abstract void setValue(@NotNull Vector3d var1, double var2);
}

