/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo;

import java.util.Objects;
import me.m56738.easyarmorstands.lib.gizmo.AbstractGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.GizmoAxis;
import me.m56738.easyarmorstands.lib.gizmo.api.LineGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractLineGizmo
extends AbstractGizmo
implements LineGizmo {
    private GizmoAxis axis = DEFAULT_AXIS;
    private double length = 1.0;
    private double width = 0.03125;

    @Override
    @NotNull
    public GizmoAxis getAxis() {
        return this.axis;
    }

    @Override
    public void setAxis(@NotNull GizmoAxis axis) {
        if (!Objects.equals((Object)this.axis, (Object)axis)) {
            this.axis = axis;
            this.markDirty();
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void setLength(double length) {
        if (!Objects.equals(this.length, length)) {
            this.length = length;
            this.markDirty();
        }
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double width) {
        if (!Objects.equals(this.width, width)) {
            this.width = width;
            this.markDirty();
        }
    }

    @Override
    @Nullable
    public Intersection intersect(@NotNull Cursor cursor, double threshold) {
        Vector3d start = this.getPosition().add(this.getOffset(), new Vector3d());
        Vector3d end = this.getAxis().direction().mul(this.getLength(), new Vector3d()).rotate(this.getRotation()).add(start);
        return cursor.intersectLine(start, end, threshold);
    }
}

