/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.fancyholograms.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementNode;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.display.api.property.type.BlockDisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.input.OpenElementMenuInput;
import me.m56738.easyarmorstands.editor.input.ReturnInput;
import me.m56738.easyarmorstands.editor.node.PropertyMenuNode;
import me.m56738.easyarmorstands.editor.node.ToolMenuModeSwitcher;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElement;
import me.m56738.easyarmorstands.message.Message;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HologramRootNode
extends PropertyMenuNode
implements ElementNode {
    private final Session session;
    private final HologramElement element;
    private final ToolMenuModeSwitcher toolSwitcher;
    private final Property<BlockData> blockDataProperty;
    private final boolean allowMenu;

    public HologramRootNode(Session session, HologramElement element) {
        super(session, session.properties(element));
        this.session = session;
        this.element = element;
        this.toolSwitcher = new ToolMenuModeSwitcher(new ToolMenuManager(session, this, element.getTools(this.properties())));
        this.blockDataProperty = this.properties().getOrNull(BlockDisplayPropertyTypes.BLOCK);
        this.allowMenu = session.player().hasPermission("easyarmorstands.open");
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        BlockData blockData;
        Block block;
        if (super.onClick(context)) {
            return true;
        }
        Player player = this.session.player();
        if (this.blockDataProperty != null && context.type() == ClickContext.Type.LEFT_CLICK && player.isSneaking() && (block = context.block()) != null && this.blockDataProperty.setValue(blockData = block.getBlockData())) {
            this.properties().commit();
            new EasPlayer(player).sendMessage(Message.success("easyarmorstands.success.changed-block", this.blockDataProperty.getType().getValueComponent(blockData)));
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        super.onUpdate(context);
        context.setActionBar(this.toolSwitcher.getActionBar());
        this.toolSwitcher.onUpdate(context);
        if (this.allowMenu) {
            context.addInput(new OpenElementMenuInput(this.session, this.element));
        }
        context.addInput(new ReturnInput(this.session));
    }

    @Override
    @NotNull
    public HologramElement getElement() {
        return this.element;
    }
}

