/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.tool.ToolSession;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ToolNode
implements Node {
    private final Session session;
    private final ToolSession toolSession;
    private final Component name;

    public ToolNode(Session session, ToolSession toolSession, Component name) {
        this.session = session;
        this.toolSession = toolSession;
        this.name = name;
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        this.toolSession.commit(this.toolSession.getDescription());
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        this.updateActionBar(context);
    }

    protected void updateActionBar(@NotNull UpdateContext context) {
        TextComponent.Builder builder = Component.text();
        builder.append(this.name);
        Component state = this.toolSession.getStatus();
        if (state != null) {
            builder.append((Component)Component.text(": "));
            builder.append(state);
        }
        context.setActionBar(builder);
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        if (context.type() == ClickContext.Type.LEFT_CLICK) {
            this.toolSession.revert();
            this.session.popNode();
            return true;
        }
        if (context.type() == ClickContext.Type.RIGHT_CLICK) {
            this.session.popNode();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.toolSession.isValid();
    }

    @NotNull
    public Component getName() {
        return this.name;
    }
}

