/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementSelectionNode;
import me.m56738.easyarmorstands.api.editor.node.MenuNode;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.element.ElementDiscoveryEntry;
import me.m56738.easyarmorstands.api.element.ElementDiscoverySource;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.editor.input.OpenSpawnMenuInput;
import me.m56738.easyarmorstands.editor.input.selection.AddElementToGroupInput;
import me.m56738.easyarmorstands.editor.input.selection.ClearGroupSelectionInput;
import me.m56738.easyarmorstands.editor.input.selection.RemoveElementFromGroupInput;
import me.m56738.easyarmorstands.editor.input.selection.SelectElementInput;
import me.m56738.easyarmorstands.editor.input.selection.SelectGroupInput;
import me.m56738.easyarmorstands.editor.input.selection.box.CancelBoxSelectionInput;
import me.m56738.easyarmorstands.editor.input.selection.box.ConfirmBoxSelectionInput;
import me.m56738.easyarmorstands.editor.input.selection.box.StartBoxSelectionInput;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.message.MessageStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ElementSelectionNodeImpl
extends MenuNode
implements ElementSelectionNode {
    private final Session session;
    private final Map<ElementDiscoveryEntry, ElementEntry> entries = new HashMap<ElementDiscoveryEntry, ElementEntry>();
    private final Component name;
    private final Set<ElementDiscoverySource> sources = new LinkedHashSet<ElementDiscoverySource>();
    private final Map<ElementDiscoveryEntry, SelectableElement> groupMembers = new LinkedHashMap<ElementDiscoveryEntry, SelectableElement>();
    private final Map<ElementDiscoveryEntry, SelectableElement> selectionBoxMembers = new LinkedHashMap<ElementDiscoveryEntry, SelectableElement>();
    private final Vector3d selectionBoxOrigin = new Vector3d();
    private final double selectionCursorOffset = 2.0;
    private final BoundingBoxParticle selectionBoxParticle;
    private final OpenSpawnMenuInput openSpawnMenuInput;
    private final boolean allowGroups;
    private final boolean allowSpawn;
    private BoundingBox selectionBox;
    private boolean selectionBoxEditing;
    private double range;
    private double boxSizeLimit;
    private int buttonLimit;
    private int groupLimit;
    private int buttonCount;

    public ElementSelectionNodeImpl(Session session) {
        super(session);
        this.range = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.range;
        this.boxSizeLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.group.range;
        this.buttonLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.discovery.limit;
        this.groupLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.group.limit;
        this.session = session;
        this.name = Message.component("easyarmorstands.node.select-entity");
        this.selectionBoxParticle = session.particleProvider().createAxisAlignedBox();
        this.openSpawnMenuInput = new OpenSpawnMenuInput(session);
        this.allowGroups = session.player().hasPermission("easyarmorstands.group");
        this.allowSpawn = session.player().hasPermission("easyarmorstands.spawn");
    }

    @Override
    public double getRange() {
        return this.range;
    }

    @Override
    public void setRange(double range) {
        this.range = range;
    }

    @Override
    public void addSource(@NotNull ElementDiscoverySource source) {
        this.sources.add(source);
    }

    @Override
    public void removeSource(@NotNull ElementDiscoverySource source) {
        this.sources.remove(source);
    }

    @Override
    public @Unmodifiable @NotNull Iterable<ElementDiscoverySource> getSources() {
        return Collections.unmodifiableSet(new HashSet<ElementDiscoverySource>(this.sources));
    }

    public void startBoxSelection(EyeRay eyeRay) {
        this.selectionBoxOrigin.set(eyeRay.point(2.0));
        if (this.selectionBox != null) {
            this.session.removeParticle(this.selectionBoxParticle);
        }
        this.selectionBox = BoundingBox.of((Vector3dc)this.selectionBoxOrigin);
        this.selectionBoxParticle.setBoundingBox(this.selectionBox);
        this.selectionBoxParticle.setColor(ParticleColor.YELLOW);
        this.selectionBoxEditing = true;
        this.session.addParticle(this.selectionBoxParticle);
    }

    public void finishBoxSelection() {
        this.selectionBoxEditing = false;
        this.groupMembers.putAll(this.selectionBoxMembers);
        this.selectionBoxMembers.clear();
        this.selectionBoxParticle.setColor(ParticleColor.GRAY);
    }

    public void cancelBoxSelection() {
        if (this.selectionBox == null) {
            return;
        }
        this.selectionBoxEditing = false;
        this.selectionBox = null;
        this.session.removeParticle(this.selectionBoxParticle);
        this.selectionBoxMembers.clear();
    }

    public void clearGroupSelection() {
        this.groupMembers.clear();
    }

    public void addToGroup(ElementDiscoveryEntry discoveryEntry, SelectableElement element) {
        this.groupMembers.put(discoveryEntry, element);
    }

    public void removeFromGroup(ElementDiscoveryEntry discoveryEntry, SelectableElement element) {
        this.groupMembers.remove(discoveryEntry, element);
    }

    private BoundingBox getDiscoveryBox(EyeRay eyeRay) {
        Vector3dc origin = eyeRay.origin();
        Vector3d halfSize = new Vector3d(this.range);
        return BoundingBox.of((Vector3dc)origin.sub(halfSize, new Vector3d()), (Vector3dc)origin.add(halfSize, new Vector3d()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        int groupSize;
        ElementButton button;
        if (this.selectionBoxEditing) {
            Vector3dc cursor = context.eyeRay().point(2.0);
            this.selectionBox = BoundingBox.of((Vector3dc)this.selectionBoxOrigin, cursor);
            Vector3d size = this.selectionBox.getSize(new Vector3d());
            double maxSize = size.get(size.maxComponent());
            if (maxSize > this.boxSizeLimit) {
                this.cancelBoxSelection();
            }
        }
        EyeRay eyeRay = context.eyeRay();
        BoundingBox box = this.getDiscoveryBox(eyeRay);
        HashSet<ElementDiscoveryEntry> foundEntries = new HashSet<ElementDiscoveryEntry>(this.groupMembers.keySet());
        for (ElementDiscoverySource elementDiscoverySource : this.sources) {
            elementDiscoverySource.discover(eyeRay.world(), box, foundEntries::add);
        }
        Iterator<Object> iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ElementDiscoveryEntry, ElementEntry> entry = iterator.next();
            if (foundEntries.contains(entry.getKey())) continue;
            button = entry.getValue().button;
            if (button != null) {
                this.removeButton(button);
                --this.buttonCount;
            }
            iterator.remove();
        }
        for (ElementDiscoveryEntry elementDiscoveryEntry : foundEntries) {
            if (this.isButtonLimitReached()) break;
            this.entries.computeIfAbsent(elementDiscoveryEntry, this::addEntry);
        }
        if (this.selectionBox != null) {
            this.selectionBoxParticle.setBoundingBox(this.selectionBox);
            this.selectionBoxMembers.values().removeIf(e -> !e.isValid() || !e.getBoundingBox().overlaps(this.selectionBox));
            for (ElementEntry elementEntry : this.entries.values()) {
                SelectableElement element;
                button = elementEntry.button;
                if (button == null || !(element = button.element).getBoundingBox().overlaps(this.selectionBox)) continue;
                if (this.groupMembers.size() + this.selectionBoxMembers.size() >= this.groupLimit) break;
                this.selectionBoxMembers.putIfAbsent(button.entry, element);
                this.groupMembers.remove(button.entry);
            }
            if (!this.selectionBoxEditing) {
                this.groupMembers.putAll(this.selectionBoxMembers);
                this.selectionBoxMembers.clear();
            }
        }
        this.groupMembers.values().removeIf(e -> !e.isValid());
        if (this.selectionBoxEditing) {
            context.addInput(new ConfirmBoxSelectionInput(this));
        }
        if (!this.groupMembers.isEmpty()) {
            context.addInput(new SelectGroupInput(this.session, this.groupMembers.values()));
        }
        super.onUpdate(context);
        if (this.selectionBox != null) {
            context.addInput(new CancelBoxSelectionInput(this));
        }
        if (!this.groupMembers.isEmpty()) {
            context.addInput(new ClearGroupSelectionInput(this));
        }
        if (this.selectionBox == null && this.allowGroups) {
            context.addInput(new StartBoxSelectionInput(this));
        }
        if (this.groupMembers.isEmpty() && this.selectionBox == null && this.allowSpawn) {
            context.addInput(this.openSpawnMenuInput);
        }
        if ((groupSize = this.groupMembers.size() + this.selectionBoxMembers.size()) == 0) {
            if (this.isButtonLimitReached()) {
                context.setActionBar(Message.error("easyarmorstands.node.select-entity.limit-reached"));
            } else {
                context.setActionBar(this.name);
            }
        } else if (groupSize == 1) {
            context.setActionBar(Message.component("easyarmorstands.node.group-selected.single"));
        } else {
            void var6_17;
            Component component = Message.component("easyarmorstands.node.group-selected", Component.text(groupSize));
            if (groupSize >= this.groupLimit) {
                Component component2 = Message.format(MessageStyle.ERROR, component);
            }
            context.setActionBar((ComponentLike)var6_17);
        }
    }

    private boolean isButtonLimitReached() {
        return this.buttonLimit > 0 && this.buttonCount >= this.buttonLimit;
    }

    private ElementEntry addEntry(ElementDiscoveryEntry entry) {
        SelectableElement element = entry.getElement();
        EasPlayer context = new EasPlayer(this.session.player());
        if (element == null || !context.canDiscoverElement(element)) {
            return ElementEntry.EMPTY;
        }
        ElementButton button = new ElementButton(entry, this.session, element);
        this.addButton(button);
        ++this.buttonCount;
        return new ElementEntry(button);
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        super.onExit(context);
        for (ElementEntry entry : this.entries.values()) {
            if (entry.button == null) continue;
            this.removeButton(entry.button);
        }
        this.entries.clear();
        this.buttonCount = 0;
        this.cancelBoxSelection();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean selectElement(@NotNull SelectableElement element) {
        EasPlayer context = new EasPlayer(this.session.player());
        if (!context.canEditElement(element)) {
            return false;
        }
        Node node = element.createNode(this.session);
        this.session.returnToNode(this);
        this.session.pushNode(node);
        return true;
    }

    @Override
    public boolean selectElements(@NotNull List<? extends SelectableElement> elements) {
        if (elements.size() == 1) {
            return this.selectElement(elements.get(0));
        }
        Group group = new Group(this.session);
        EasPlayer context = new EasPlayer(this.session.player());
        for (SelectableElement selectableElement : elements) {
            if (!context.canEditElement(selectableElement)) continue;
            group.addMember(selectableElement);
        }
        if (!group.isValid()) {
            return false;
        }
        this.session.returnToNode(this);
        this.session.pushNode(new GroupRootNode(group));
        return true;
    }

    private static class ElementEntry {
        private static final ElementEntry EMPTY = new ElementEntry(null);
        @Nullable
        private final ElementButton button;

        private ElementEntry(@Nullable ElementButton button) {
            this.button = button;
        }
    }

    private class ElementButton
    implements MenuButton {
        private final ElementDiscoveryEntry entry;
        private final SelectableElement element;
        private final Button button;
        private final SelectElementInput selectInput;
        private final AddElementToGroupInput addToGroupInput;
        private final RemoveElementFromGroupInput removeFromGroupInput;

        private ElementButton(ElementDiscoveryEntry entry, Session session, SelectableElement element) {
            this.entry = entry;
            this.element = element;
            this.button = element.createButton(session);
            this.selectInput = new SelectElementInput(session, element);
            this.addToGroupInput = new AddElementToGroupInput(ElementSelectionNodeImpl.this, entry, element);
            this.removeFromGroupInput = new RemoveElementFromGroupInput(ElementSelectionNodeImpl.this, entry, element);
        }

        @Override
        @NotNull
        public Button getButton() {
            return this.button;
        }

        @Override
        public void onUpdate(@NotNull Session session, @NotNull UpdateContext context) {
            context.addInput(this.selectInput);
            if (ElementSelectionNodeImpl.this.allowGroups && ElementSelectionNodeImpl.this.selectionBox == null) {
                if (!ElementSelectionNodeImpl.this.groupMembers.containsKey(this.entry)) {
                    if (ElementSelectionNodeImpl.this.groupMembers.size() < ElementSelectionNodeImpl.this.groupLimit) {
                        context.addInput(this.addToGroupInput);
                    }
                } else {
                    context.addInput(this.removeFromGroupInput);
                }
            }
        }

        @Override
        @NotNull
        public Component getName() {
            return this.element.getName();
        }

        @Override
        public boolean isAlwaysFocused() {
            return ElementSelectionNodeImpl.this.groupMembers.containsKey(this.entry) || ElementSelectionNodeImpl.this.selectionBoxMembers.containsKey(this.entry);
        }
    }
}

