/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.input.selection;

import java.util.Collection;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.input.Input;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;

public class SelectGroupInput
implements Input {
    private static final Component NAME = Component.translatable("easyarmorstands.input.select.group");
    private static final Style STYLE = Style.style(NamedTextColor.GREEN);
    private final Session session;
    private final Collection<SelectableElement> elements;

    public SelectGroupInput(Session session, Collection<SelectableElement> elements) {
        this.session = session;
        this.elements = elements;
    }

    @Override
    @NotNull
    public Component name() {
        return NAME;
    }

    @Override
    @NotNull
    public Style style() {
        return STYLE;
    }

    @Override
    public @NotNull ClickContext.Type clickType() {
        return ClickContext.Type.RIGHT_CLICK;
    }

    @Override
    public boolean allowSneak() {
        return false;
    }

    @Override
    public void execute(@NotNull ClickContext context) {
        int size = this.elements.size();
        if (size > 1) {
            Group group = new Group(this.session);
            for (SelectableElement element : this.elements) {
                group.addMember(element);
            }
            this.session.pushNode(new GroupRootNode(group));
        } else {
            SelectableElement element = this.elements.iterator().next();
            this.session.pushNode(element.createNode(this.session));
        }
    }
}

