/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.input.selection;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.input.Input;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;

public class SelectElementInput
implements Input {
    private static final Component NAME = Component.translatable("easyarmorstands.input.select");
    private static final Style STYLE = Style.style(NamedTextColor.GREEN);
    private final Session session;
    private final SelectableElement element;

    public SelectElementInput(Session session, SelectableElement element) {
        this.session = session;
        this.element = element;
    }

    @Override
    @NotNull
    public Component name() {
        return NAME;
    }

    @Override
    @NotNull
    public Style style() {
        return STYLE;
    }

    @Override
    public @NotNull ClickContext.Type clickType() {
        return ClickContext.Type.RIGHT_CLICK;
    }

    @Override
    public boolean allowSneak() {
        return false;
    }

    @Override
    public void execute(@NotNull ClickContext context) {
        EasPlayer changeContext = new EasPlayer(this.session.player());
        if (!changeContext.canEditElement(this.element)) {
            return;
        }
        Node node = this.element.createNode(this.session);
        this.session.pushNode(node);
    }
}

