/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.box;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.editor.box.BoundingBoxEditor;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;

public class BoxSidePositionProvider
implements PositionProvider {
    private final BoundingBoxEditor editor;
    private final Vector3dc offset;
    private final Vector3d center = new Vector3d();
    private final Vector3d size = new Vector3d();

    public BoxSidePositionProvider(BoundingBoxEditor editor, Axis axis, boolean end) {
        this(editor, BoxSidePositionProvider.getOffset(axis, end));
    }

    public BoxSidePositionProvider(BoundingBoxEditor editor, Vector3dc offset) {
        this.editor = editor;
        this.offset = new Vector3d(offset);
    }

    private static Vector3dc getOffset(Axis axis, boolean end) {
        Vector3d offset = new Vector3d(axis.getDirection());
        if (end) {
            offset.mul(0.5);
        } else {
            offset.mul(-0.5);
        }
        return offset;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        this.editor.getBoundingBox().getCenter(this.center);
        this.editor.getBoundingBox().getSize(this.size);
        return this.offset.mul(this.size, new Vector3d()).add(this.center);
    }
}

