/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.armorstand.node;

import java.util.EnumMap;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.ArmorStandPart;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.AddContext;
import me.m56738.easyarmorstands.api.editor.context.RemoveContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementNode;
import me.m56738.easyarmorstands.api.editor.node.MenuNode;
import me.m56738.easyarmorstands.api.editor.node.ResettableNode;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.ArmorStandPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.capability.glow.GlowCapability;
import me.m56738.easyarmorstands.capability.persistence.PersistenceCapability;
import me.m56738.easyarmorstands.capability.spawn.SpawnCapability;
import me.m56738.easyarmorstands.capability.tick.TickCapability;
import me.m56738.easyarmorstands.capability.visibility.VisibilityCapability;
import me.m56738.easyarmorstands.editor.armorstand.ArmorStandOffsetProvider;
import me.m56738.easyarmorstands.editor.armorstand.button.ArmorStandPartButton;
import me.m56738.easyarmorstands.editor.armorstand.button.ArmorStandPositionButton;
import me.m56738.easyarmorstands.editor.input.OpenElementMenuInput;
import me.m56738.easyarmorstands.editor.input.ReturnInput;
import me.m56738.easyarmorstands.element.ArmorStandElement;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.jetbrains.annotations.NotNull;

public class ArmorStandRootNode
extends MenuNode
implements ElementNode,
ResettableNode {
    private final Session session;
    private final ArmorStand entity;
    private final ArmorStandElement element;
    private final ArmorStandPositionButton positionButton;
    private final EnumMap<ArmorStandPart, ArmorStandPartButton> partButtons = new EnumMap(ArmorStandPart.class);
    private final PropertyContainer container;
    private final Component name;
    private final boolean allowMenu;
    private ArmorStand skeleton;

    public ArmorStandRootNode(Session session, ArmorStand entity, ArmorStandElement element) {
        super(session);
        this.session = session;
        this.entity = entity;
        this.element = element;
        this.container = session.properties(element);
        this.name = Message.component("easyarmorstands.node.select-bone");
        this.allowMenu = session.player().hasPermission("easyarmorstands.open");
        for (ArmorStandPart part : ArmorStandPart.values()) {
            ArmorStandPartButton partButton = new ArmorStandPartButton(session, this.container, part, element);
            this.addButton(partButton);
            this.partButtons.put(part, partButton);
        }
        this.positionButton = new ArmorStandPositionButton(session, ParticleColor.WHITE, Message.component("easyarmorstands.node.position"), this.container, new ArmorStandOffsetProvider(element, this.container), element);
        this.addButton(this.positionButton);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        super.onUpdate(context);
        if (this.skeleton != null) {
            this.updateSkeleton(this.skeleton);
        }
        context.setActionBar(this.name);
        if (this.allowMenu) {
            context.addInput(new OpenElementMenuInput(this.session, this.element));
        }
        context.addInput(new ReturnInput(this.session));
    }

    @Override
    public void onInactiveUpdate(@NotNull UpdateContext context) {
        super.onInactiveUpdate(context);
        if (this.skeleton != null) {
            this.updateSkeleton(this.skeleton);
        }
    }

    public ArmorStandPositionButton getPositionButton() {
        return this.positionButton;
    }

    public ArmorStandPartButton getPartButton(ArmorStandPart part) {
        return this.partButtons.get((Object)part);
    }

    @Override
    public void onAdd(@NotNull AddContext context) {
        EasyArmorStandsPlugin plugin;
        GlowCapability glowCapability;
        if (this.skeleton != null) {
            this.skeleton.remove();
        }
        if ((glowCapability = (plugin = EasyArmorStandsPlugin.getInstance()).getCapability(GlowCapability.class)) != null && !this.session.particleProvider().isVisibleThroughWalls()) {
            SpawnCapability spawnCapability = plugin.getCapability(SpawnCapability.class);
            this.skeleton = spawnCapability.spawnEntity(this.entity.getLocation(), ArmorStand.class, e -> {
                TickCapability tickCapability;
                e.setVisible(false);
                e.setBasePlate(false);
                e.setArms(true);
                e.setGravity(false);
                PersistenceCapability persistenceCapability = plugin.getCapability(PersistenceCapability.class);
                if (persistenceCapability != null) {
                    persistenceCapability.setPersistent((Entity)e, false);
                }
                if ((tickCapability = plugin.getCapability(TickCapability.class)) != null) {
                    tickCapability.setCanTick((ArmorStand)e, false);
                }
                this.updateSkeleton((ArmorStand)e);
                VisibilityCapability visibilityCapability = plugin.getCapability(VisibilityCapability.class);
                if (visibilityCapability != null) {
                    Player player = this.session.player();
                    for (Player other : Bukkit.getOnlinePlayers()) {
                        if (player == other) continue;
                        visibilityCapability.hideEntity(other, (Plugin)plugin, (Entity)e);
                    }
                }
                glowCapability.setGlowing((Entity)e, true);
            });
        } else {
            this.skeleton = null;
        }
    }

    private void updateSkeleton(ArmorStand skeleton) {
        skeleton.teleport(this.entity.getLocation());
        skeleton.setSmall(this.entity.isSmall());
        for (ArmorStandPart part : ArmorStandPart.values()) {
            part.setPose(skeleton, part.getPose(this.entity));
        }
    }

    public void hideSkeleton(Player player) {
        EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
        VisibilityCapability visibilityCapability = plugin.getCapability(VisibilityCapability.class);
        if (this.skeleton != null && visibilityCapability != null) {
            visibilityCapability.hideEntity(player, (Plugin)plugin, (Entity)this.skeleton);
        }
    }

    @Override
    public void onRemove(@NotNull RemoveContext context) {
        if (this.skeleton != null) {
            this.skeleton.remove();
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isValid();
    }

    @Override
    @NotNull
    public Element getElement() {
        return this.element;
    }

    @Override
    public void reset() {
        Property<Location> locationProperty = this.container.get(EntityPropertyTypes.LOCATION);
        Location location = locationProperty.getValue();
        location.setYaw(0.0f);
        location.setPitch(0.0f);
        locationProperty.setValue(location);
        for (ArmorStandPart part : ArmorStandPart.values()) {
            this.container.get(ArmorStandPropertyTypes.POSE.get(part)).setValue(EulerAngle.ZERO);
        }
        this.container.commit();
    }
}

