/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.armorstand.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ResettableNode;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.editor.EntityPositionProvider;
import me.m56738.easyarmorstands.editor.OffsetProvider;
import me.m56738.easyarmorstands.editor.input.ReturnInput;
import me.m56738.easyarmorstands.editor.node.PropertyMenuNode;
import me.m56738.easyarmorstands.editor.node.ToolMenuModeSwitcher;
import me.m56738.easyarmorstands.editor.tool.DelegateToolProvider;
import me.m56738.easyarmorstands.element.ArmorStandElement;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class ArmorStandPositionNode
extends PropertyMenuNode
implements ResettableNode {
    private final Session session;
    private final ToolMenuManager toolManager;
    private final ToolMenuModeSwitcher toolSwitcher;

    public ArmorStandPositionNode(Session session, PropertyContainer properties, OffsetProvider offsetProvider, ArmorStandElement element) {
        super(session, properties);
        this.session = session;
        this.toolManager = new ToolMenuManager(session, this, new DelegateToolProvider(element.getTools(properties), new EntityPositionProvider(properties, offsetProvider), null));
        this.toolSwitcher = new ToolMenuModeSwitcher(this.toolManager);
    }

    @Override
    public void reset() {
        Property<Location> locationProperty = this.properties().get(EntityPropertyTypes.LOCATION);
        Location location = locationProperty.getValue();
        location.setYaw(0.0f);
        location.setPitch(0.0f);
        locationProperty.setValue(location);
        this.properties().commit();
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        super.onUpdate(context);
        context.setActionBar(this.toolSwitcher.getActionBar());
        this.toolSwitcher.onUpdate(context);
        context.addInput(new ReturnInput(this.session));
    }
}

