/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.node.ResettableNode;
import me.m56738.easyarmorstands.api.editor.tool.ScaleToolSession;
import me.m56738.easyarmorstands.api.editor.tool.Tool;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.element.EditableElement;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.element.MenuElement;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.ArmorStandPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.MannequinPropertyTypes;
import me.m56738.easyarmorstands.capability.entitytag.EntityTagCapability;
import me.m56738.easyarmorstands.command.annotation.PropertyPermission;
import me.m56738.easyarmorstands.command.processor.ElementSelectionProcessor;
import me.m56738.easyarmorstands.command.requirement.RequireElement;
import me.m56738.easyarmorstands.command.requirement.RequireElementSelection;
import me.m56738.easyarmorstands.command.requirement.RequireSession;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.command.util.ElementSelection;
import me.m56738.easyarmorstands.editor.node.ValueNode;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.history.action.ElementCreateAction;
import me.m56738.easyarmorstands.history.action.ElementDestroyAction;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Greedy;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Range;
import me.m56738.easyarmorstands.lib.cloud.annotations.Argument;
import me.m56738.easyarmorstands.lib.cloud.annotations.Command;
import me.m56738.easyarmorstands.lib.cloud.annotations.CommandDescription;
import me.m56738.easyarmorstands.lib.cloud.annotations.Default;
import me.m56738.easyarmorstands.lib.cloud.annotations.Permission;
import me.m56738.easyarmorstands.lib.cloud.annotations.suggestion.Suggestions;
import me.m56738.easyarmorstands.lib.cloud.bukkit.data.MultipleEntitySelector;
import me.m56738.easyarmorstands.lib.cloud.bukkit.data.SingleEntitySelector;
import me.m56738.easyarmorstands.lib.cloud.context.CommandContext;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.annotation.specifier.Decoder;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.ClickEvent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.HoverEventSource;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.MiniMessage;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.property.TrackedPropertyContainer;
import me.m56738.easyarmorstands.property.armorstand.ArmorStandCanTickProperty;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.util.AlignAxis;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

@Command(value="eas")
public class SessionCommands {
    public static void showText(Audience audience, Component type, @Nullable Component text, String command) {
        String serialized = MiniMessage.miniMessage().serializeOr(text, "");
        audience.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Message.title(type))).append((Component)Component.space())).append(Message.chatButton("easyarmorstands.button.text.edit").hoverEvent((HoverEventSource)Message.hover("easyarmorstands.click-to-edit")).clickEvent(ClickEvent.suggestCommand(command + " " + serialized)))).append((Component)Component.space())).append(Message.chatButton("easyarmorstands.button.text.copy").hoverEvent((HoverEventSource)Message.hover("easyarmorstands.click-to-copy")).clickEvent(ClickEvent.copyToClipboard(serialized)))).append((Component)Component.space())).append(Message.chatButton("easyarmorstands.button.text.syntax-help").hoverEvent((HoverEventSource)Message.hover("easyarmorstands.click-to-open-minimessage")).clickEvent(ClickEvent.openUrl("https://docs.advntr.dev/minimessage/format.html"))));
        if (text == null) {
            audience.sendMessage(Message.hint("easyarmorstands.hint.not-set"));
        } else {
            audience.sendMessage(text);
        }
    }

    @Command(value="open")
    @Permission(value={"easyarmorstands.open"})
    @CommandDescription(value="easyarmorstands.command.description.open")
    @RequireElement
    public void open(EasPlayer sender, Element element) {
        if (!(element instanceof MenuElement)) {
            sender.sendMessage(Message.error("easyarmorstands.error.menu-unsupported"));
            return;
        }
        MenuElement menuElement = (MenuElement)element;
        menuElement.openMenu(sender.get());
    }

    @Command(value="open <entity>")
    @Permission(value={"easyarmorstands.open"})
    @CommandDescription(value="easyarmorstands.command.description.open.entity")
    public void open(EasPlayer sender, @Argument(value="entity") SingleEntitySelector selector) {
        Entity entity = (Entity)selector.single();
        Element element = EasyArmorStandsPlugin.getInstance().entityElementProviderRegistry().getElement(entity);
        if (element == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.unsupported-entity"));
            return;
        }
        if (!(element instanceof MenuElement)) {
            sender.sendMessage(Message.error("easyarmorstands.error.menu-unsupported"));
            return;
        }
        MenuElement menuElement = (MenuElement)element;
        if (!menuElement.canEdit(sender.get())) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-edit"));
            return;
        }
        menuElement.openMenu(sender.get());
    }

    @Command(value="select <entities>")
    @Permission(value={"easyarmorstands.select"})
    @CommandDescription(value="easyarmorstands.command.description.select")
    @RequireSession
    public void select(EasPlayer sender, Session session, @Argument(value="entities") MultipleEntitySelector selector) {
        this.selectGroup(sender, session, selector.values().stream().map(EasyArmorStandsPlugin.getInstance().entityElementProviderRegistry()::getElement).filter(element -> element instanceof EditableElement).map(element -> (EditableElement)element).filter(sender::canEditElement).iterator());
    }

    @Command(value="clone")
    @Permission(value={"easyarmorstands.clone"})
    @CommandDescription(value="easyarmorstands.command.description.clone")
    @RequireElementSelection
    public void clone(EasPlayer sender, ElementSelection selection) {
        Component description;
        ArrayList<Element> clones = new ArrayList<Element>();
        for (Element element : selection.elements()) {
            Element clone;
            PropertyContainer properties;
            ElementType type = element.getType();
            if (!sender.canCreateElement(type, properties = PropertyContainer.immutable(element.getProperties())) || (clone = type.createElement(properties)) == null) continue;
            clones.add(clone);
        }
        int count = clones.size();
        if (count == 0) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-clone"));
            return;
        }
        if (count == 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-cloned"));
            description = Message.component("easyarmorstands.history.clone-element");
        } else {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-cloned.multiple", Component.text(count)));
            description = Message.component("easyarmorstands.history.clone-group");
        }
        ArrayList<ElementCreateAction> actions = new ArrayList<ElementCreateAction>();
        for (Element clone : clones) {
            actions.add(new ElementCreateAction(clone));
        }
        sender.history().push(actions, description);
    }

    @Command(value="spawn")
    @Permission(value={"easyarmorstands.spawn"})
    @CommandDescription(value="easyarmorstands.command.description.spawn")
    public void spawn(EasPlayer sender) {
        Player player = sender.get();
        Menu menu = EasyArmorStandsPlugin.getInstance().createSpawnMenu(player);
        player.openInventory(menu.getInventory());
    }

    @Command(value="destroy")
    @Permission(value={"easyarmorstands.destroy"})
    @CommandDescription(value="easyarmorstands.command.description.destroy")
    @RequireElementSelection
    public void destroy(EasPlayer sender, ElementSelection selection) {
        ArrayList<ElementDestroyAction> actions = new ArrayList<ElementDestroyAction>();
        for (Element element : selection.elements()) {
            DestroyableElement destroyableElement;
            if (!(element instanceof DestroyableElement) || !sender.canDestroyElement(destroyableElement = (DestroyableElement)element)) continue;
            actions.add(new ElementDestroyAction(element));
            destroyableElement.destroy();
        }
        int count = actions.size();
        sender.history().push(actions, Message.component("easyarmorstands.history.destroy-elements", Component.text(count)));
        if (count > 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-destroyed.multiple", Component.text(count)));
        } else if (count == 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-destroyed"));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.destroy-unsupported"));
        }
    }

    @Command(value="snap angle [value]")
    @Permission(value={"easyarmorstands.snap"})
    @CommandDescription(value="easyarmorstands.command.description.snap.angle")
    @RequireSession
    public void setAngleSnapIncrement(EasPlayer sender, SessionImpl session, @Argument(value="value") @Range(min="0", max="90") Double value) {
        if (value == null) {
            value = 0.02454369260617026;
            if (value.doubleValue() == session.snapper().getAngleIncrement()) {
                value = 0.0;
            }
        } else {
            value = Math.toRadians(value);
        }
        session.snapper().setAngleIncrement(value);
        sender.sendMessage(Message.success("easyarmorstands.success.snap-changed.angle", Component.text(Math.toDegrees(value))));
    }

    @Command(value="snap move [value]")
    @Permission(value={"easyarmorstands.snap"})
    @CommandDescription(value="easyarmorstands.command.description.snap.move")
    @RequireSession
    public void setSnapIncrement(EasPlayer sender, SessionImpl session, @Argument(value="value") @Range(min="0", max="10") Double value) {
        if (value == null && (value = Double.valueOf(0.03125)).doubleValue() == session.snapper().getPositionIncrement()) {
            value = 0.0;
        }
        session.snapper().setOffsetIncrement(value);
        session.snapper().setPositionIncrement(value);
        sender.sendMessage(Message.success("easyarmorstands.success.snap-changed.position", Component.text(value)));
    }

    @Command(value="align [axis] [value] [offset]")
    @Permission(value={"easyarmorstands.align"})
    @CommandDescription(value="easyarmorstands.command.description.align")
    @RequireElement
    public void align(EasPlayer sender, Element element, @Argument(value="axis") @Default(value="all") AlignAxis axis, @Argument(value="value") @Range(min="0.001", max="1") Double value, @Argument(value="offset") @Range(min="-1", max="1") Double offset) {
        TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
        Property<Location> property = properties.get(EntityPropertyTypes.LOCATION);
        Vector3d offsetVector = new Vector3d();
        if (value == null) {
            value = 1.0;
            offsetVector.set(0.5, 0.0, 0.5);
        } else if (offset != null) {
            offsetVector.set(offset, offset, offset);
        }
        Location location = property.getValue();
        Vector3d position = axis.snap(Util.toVector3d(location), value, offsetVector, new Vector3d());
        location.setX(position.x());
        location.setY(position.y());
        location.setZ(position.z());
        if (!property.setValue(location)) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-move"));
            return;
        }
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.moved", Util.formatPosition(position)));
    }

    @Command(value="name")
    @PropertyPermission(value="easyarmorstands:entity/custom_name")
    @CommandDescription(value="easyarmorstands.command.description.name")
    @RequireElementSelection
    public void showName(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> property = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.name-unsupported"));
            return;
        }
        Component text = property.getValue().orElse(null);
        SessionCommands.showText(sender, EntityPropertyTypes.CUSTOM_NAME.getName(), text, "/eas name set");
    }

    @Command(value="name set <value>")
    @PropertyPermission(value="easyarmorstands:entity/custom_name")
    @CommandDescription(value="easyarmorstands.command.description.name.set")
    @RequireElementSelection
    public void setName(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Decoder.MiniMessage @Greedy Component name) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> nameProperty = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME);
        if (nameProperty == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.name-unsupported"));
            return;
        }
        Property<Boolean> nameVisibleProperty = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME_VISIBLE);
        boolean hadName = nameProperty.getValue().isPresent();
        if (!nameProperty.setValue(Optional.of(name))) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
            return;
        }
        if (!hadName && nameVisibleProperty != null) {
            nameVisibleProperty.setValue(true);
        }
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.changed-name", name.colorIfAbsent(NamedTextColor.WHITE)));
    }

    @Command(value="name clear")
    @PropertyPermission(value="easyarmorstands:entity/custom_name")
    @CommandDescription(value="easyarmorstands.command.description.name.clear")
    @RequireElementSelection
    public void clearName(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> nameProperty = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME);
        if (nameProperty == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.name-unsupported"));
            return;
        }
        Property<Boolean> nameVisibleProperty = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME_VISIBLE);
        if (!nameProperty.setValue(Optional.empty())) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
            return;
        }
        if (nameVisibleProperty != null) {
            nameVisibleProperty.setValue(false);
        }
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.removed-name"));
    }

    @Command(value="name visible <value>")
    @PropertyPermission(value="easyarmorstands:entity/custom_name/visible")
    @CommandDescription(value="easyarmorstands.command.description.name.visible")
    @RequireElementSelection
    public void setNameVisible(EasPlayer sender, ElementSelection selection, @Argument(value="value") boolean visible) {
        PropertyContainer properties = selection.properties(sender);
        Property<Boolean> property = properties.getOrNull(EntityPropertyTypes.CUSTOM_NAME_VISIBLE);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.name-unsupported"));
            return;
        }
        if (!property.setValue(visible)) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
            return;
        }
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.changed-name-visibility", property.getType().getValueComponent(visible)));
    }

    @Command(value="description")
    @PropertyPermission(value="easyarmorstands:mannequin/description")
    @CommandDescription(value="easyarmorstands.command.description.description")
    @RequireElementSelection
    public void showDescription(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> property = properties.getOrNull(MannequinPropertyTypes.DESCRIPTION);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.description-unsupported"));
            return;
        }
        Component text = property.getValue().orElse(null);
        SessionCommands.showText(sender, MannequinPropertyTypes.DESCRIPTION.getName(), text, "/eas description set");
    }

    @Command(value="description set <value>")
    @PropertyPermission(value="easyarmorstands:mannequin/description")
    @CommandDescription(value="easyarmorstands.command.description.description.set")
    @RequireElementSelection
    public void setDescription(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Decoder.MiniMessage @Greedy Component description) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> property = properties.getOrNull(MannequinPropertyTypes.DESCRIPTION);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.description-unsupported"));
            return;
        }
        property.setValue(Optional.of(description));
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.changed-description", description.colorIfAbsent(NamedTextColor.WHITE)));
    }

    @Command(value="description clear")
    @PropertyPermission(value="easyarmorstands:mannequin/description")
    @CommandDescription(value="easyarmorstands.command.description.description.clear")
    @RequireElementSelection
    public void clearDescription(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Component>> property = properties.getOrNull(MannequinPropertyTypes.DESCRIPTION);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.description-unsupported"));
            return;
        }
        property.setValue(Optional.empty());
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.removed-description"));
    }

    @Command(value="cantick <value>")
    @PropertyPermission(value="easyarmorstands:armor_stand/can_tick")
    @CommandDescription(value="easyarmorstands.command.description.cantick")
    @RequireElementSelection
    public void setCanTick(EasPlayer sender, ElementSelection selection, @Argument(value="value") boolean canTick) {
        PropertyContainer properties = selection.properties(sender);
        Property<Boolean> property = properties.getOrNull(ArmorStandPropertyTypes.CAN_TICK);
        if (property == null) {
            if (ArmorStandCanTickProperty.isSupported()) {
                sender.sendMessage(Message.error("easyarmorstands.error.can-tick-unsupported-entity"));
            } else {
                sender.sendMessage(Message.error("easyarmorstands.error.can-tick-unsupported"));
            }
            return;
        }
        if (!property.setValue(canTick)) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
            return;
        }
        properties.commit();
        sender.sendMessage(Message.success("easyarmorstands.success.changed-can-tick", property.getType().getValueComponent(canTick)));
    }

    @Command(value="scale <value>")
    @PropertyPermission(value="easyarmorstands:entity/scale")
    @CommandDescription(value="easyarmorstands.command.description.scale.set")
    @RequireElement
    public void setScale(EasPlayer sender, Element element, @Argument(value="value") double value) {
        Tool scaleTool = null;
        if (element instanceof EditableElement) {
            TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
            ToolProvider tools = ((EditableElement)element).getTools(properties);
            scaleTool = tools.scale(ToolContext.of(tools.position(), tools.rotation()));
        }
        if (scaleTool == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.scale-unsupported"));
            return;
        }
        ScaleToolSession toolSession = (ScaleToolSession)scaleTool.start();
        toolSession.setValue(value);
        toolSession.commit(toolSession.getDescription());
        sender.sendMessage(Message.success("easyarmorstands.success.changed-scale", Util.formatScale(value)));
    }

    @Command(value="tag add <value>")
    @PropertyPermission(value="easyarmorstands:entity/tags")
    @CommandDescription(value="easyarmorstands.command.description.tag.add")
    @RequireElementSelection
    public void addTag(EasPlayer sender, ElementSelection selection, @Argument(value="value") String tag) {
        ArrayList<TrackedPropertyContainer> changed = new ArrayList<TrackedPropertyContainer>();
        for (Element element : selection.elements()) {
            TreeSet<String> tags;
            TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
            Property<Set<String>> property = properties.getOrNull(EntityPropertyTypes.TAGS);
            if (property == null || !(tags = new TreeSet<String>((Collection)property.getValue())).add(tag) || !property.setValue(tags)) continue;
            changed.add(properties);
        }
        for (PropertyContainer propertyContainer : changed) {
            propertyContainer.commit(Message.component("easyarmorstands.history.added-tag", Component.text(tag, (TextColor)NamedTextColor.WHITE)));
        }
        if (!changed.isEmpty()) {
            sender.sendMessage(Message.success("easyarmorstands.success.added-tag", Component.text(tag, (TextColor)NamedTextColor.WHITE)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-add-tag"));
        }
    }

    @Command(value="tag remove <value>")
    @PropertyPermission(value="easyarmorstands:entity/tags")
    @CommandDescription(value="easyarmorstands.command.description.tag.remove")
    @RequireElementSelection
    public void removeTag(EasPlayer sender, ElementSelection selection, @Argument(value="value", suggestions="selection_tags") String tag) {
        ArrayList<TrackedPropertyContainer> changed = new ArrayList<TrackedPropertyContainer>();
        for (Element element : selection.elements()) {
            TreeSet tags;
            TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
            Property<Set<String>> property = properties.getOrNull(EntityPropertyTypes.TAGS);
            if (property == null || !(tags = new TreeSet(property.getValue())).remove(tag) || !property.setValue(tags)) continue;
            changed.add(properties);
        }
        for (PropertyContainer propertyContainer : changed) {
            propertyContainer.commit(Message.component("easyarmorstands.history.removed-tag", Component.text(tag, (TextColor)NamedTextColor.WHITE)));
        }
        if (!changed.isEmpty()) {
            sender.sendMessage(Message.success("easyarmorstands.success.removed-tag", Component.text(tag, (TextColor)NamedTextColor.WHITE)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-remove-tag"));
        }
    }

    @Command(value="tag list")
    @PropertyPermission(value="easyarmorstands:entity/tags")
    @CommandDescription(value="easyarmorstands.command.description.tag.list")
    @RequireElementSelection
    public void listTags(EasPlayer sender, ElementSelection selection) {
        TreeSet tags = new TreeSet();
        for (Element element : selection.elements()) {
            Property<Set<String>> property = element.getProperties().getOrNull(EntityPropertyTypes.TAGS);
            if (property == null) continue;
            tags.addAll(property.getValue());
        }
        if (tags.isEmpty()) {
            sender.sendMessage(Message.warning("easyarmorstands.warning.tags-empty"));
            return;
        }
        sender.sendMessage(Message.title("easyarmorstands.title.tags"));
        for (String tag : tags) {
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().content("* ").color(NamedTextColor.GRAY)).append((Component)Component.text(tag)));
        }
    }

    @Command(value="tag select <value>")
    @Permission(value={"easyarmorstands.select.tag"})
    @CommandDescription(value="easyarmorstands.command.description.select.tag")
    @RequireSession
    public void selectTag(EasPlayer sender, Session session, @Argument(value="value", suggestions="discoverable_tags") String tag) {
        EntityTagCapability tagCapability = EasyArmorStandsPlugin.getInstance().getCapability(EntityTagCapability.class);
        if (tagCapability == null) {
            this.selectGroup(sender, session, Collections.emptyIterator());
            return;
        }
        this.selectGroup(sender, session, sender.get().getWorld().getEntities().stream().filter(entity -> tagCapability.getTags((Entity)entity).contains(tag)).map(EasyArmorStandsPlugin.getInstance().entityElementProviderRegistry()::getElement).filter(element -> element instanceof EditableElement).map(element -> (EditableElement)element).filter(sender::canEditElement).iterator());
    }

    @Suggestions(value="selection_tags")
    public Set<String> getSelectionTags(CommandContext<EasCommandSender> ctx, String input) {
        ElementSelection selection = ctx.getOrDefault(ElementSelectionProcessor.elementSelectionKey(), null);
        if (selection == null) {
            return Collections.emptySet();
        }
        TreeSet<String> tags = new TreeSet<String>();
        for (Element element : selection.elements()) {
            PropertyContainer properties = element.getProperties();
            Property<Set<String>> property = properties.getOrNull(EntityPropertyTypes.TAGS);
            if (property == null) continue;
            for (String tag : property.getValue()) {
                if (!tag.startsWith(input)) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    @Suggestions(value="discoverable_tags")
    public Set<String> getDiscoverableTags(CommandContext<EasCommandSender> ctx, String input) {
        EntityTagCapability tagCapability = EasyArmorStandsPlugin.getInstance().getCapability(EntityTagCapability.class);
        if (tagCapability == null) {
            return Collections.emptySet();
        }
        EasCommandSender sender = ctx.sender();
        if (!(sender instanceof EasPlayer)) {
            return Collections.emptySet();
        }
        EasPlayer player = (EasPlayer)sender;
        TreeSet<String> tags = new TreeSet<String>();
        for (Entity entity : player.get().getWorld().getEntities()) {
            EditableElement editableElement;
            Element element;
            Set<String> entityTags = tagCapability.getTags(entity);
            if (tags.containsAll(entityTags) || !((element = EasyArmorStandsPlugin.getInstance().entityElementProviderRegistry().getElement(entity)) instanceof EditableElement) || !player.canDiscoverElement(editableElement = (EditableElement)element)) continue;
            tags.addAll(entityTags);
        }
        return tags;
    }

    private void selectGroup(EasPlayer sender, Session session, Iterator<EditableElement> elements) {
        Group group = new Group(session);
        while (elements.hasNext()) {
            EditableElement element = elements.next();
            if (group.getMembers().size() >= EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.group.limit) {
                sender.sendMessage(Message.error("easyarmorstands.error.group-too-big"));
                return;
            }
            if (group.getMembers().size() == 1 && !sender.get().hasPermission("easyarmorstands.group")) {
                sender.sendMessage(Message.error("easyarmorstands.error.found-multiple-entities"));
                return;
            }
            group.addMember(element);
        }
        int size = group.getMembers().size();
        if (size > 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-selected.multiple", Component.text(size)));
        } else if (size == 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.entity-selected"));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.entity-not-found"));
            return;
        }
        GroupRootNode node = new GroupRootNode(group);
        session.pushNode(node);
    }

    @Command(value="reset")
    @Permission(value={"easyarmorstands.edit"})
    @CommandDescription(value="easyarmorstands.command.description.reset")
    @RequireSession
    public void reset(EasPlayer sender, Session session) {
        Node node = session.getNode();
        if (!(node instanceof ResettableNode)) {
            sender.sendMessage(Message.error("easyarmorstands.error.reset-unsupported"));
            return;
        }
        ResettableNode resettableNode = (ResettableNode)node;
        resettableNode.reset();
        sender.sendMessage(Message.success("easyarmorstands.success.reset-value"));
    }

    @Command(value="set <value>")
    @Permission(value={"easyarmorstands.edit"})
    @CommandDescription(value="easyarmorstands.command.description.set")
    public void set(EasCommandSender sender, ValueNode node, @Argument(value="value", parserName="node_value") Object value) {
        node.setValue(value);
        sender.sendMessage(Message.success("easyarmorstands.success.changed-value", node.getName(), node.formatValue(value)));
    }

    @Command(value="info")
    @Permission(value={"easyarmorstands.info"})
    @CommandDescription(value="easyarmorstands.command.description.info")
    @RequireElement
    public void info(EasPlayer sender, Element element) {
        sender.sendMessage(Message.title("easyarmorstands.info.title"));
        sender.sendMessage(Message.hint("easyarmorstands.info.type", element.getType().getDisplayName().colorIfAbsent(NamedTextColor.WHITE)));
        if (element instanceof EntityElement) {
            Object entity = ((EntityElement)element).getEntity();
            sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Message.hint("easyarmorstands.info.uuid", Component.text(entity.getUniqueId().toString(), (TextColor)NamedTextColor.WHITE)))).appendSpace()).append(Message.chatButton("easyarmorstands.button.text.copy").hoverEvent((HoverEventSource)Message.hover("easyarmorstands.click-to-copy")).clickEvent(ClickEvent.copyToClipboard(entity.getUniqueId().toString()))));
            sender.sendMessage(Message.hint("easyarmorstands.info.id", Component.text(entity.getEntityId(), (TextColor)NamedTextColor.WHITE)));
        }
    }
}

