/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command;

import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.command.processor.ElementProcessor;
import me.m56738.easyarmorstands.command.requirement.ElementRequirement;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.command.value.PitchCommand;
import me.m56738.easyarmorstands.command.value.PositionCommand;
import me.m56738.easyarmorstands.command.value.ValueCommand;
import me.m56738.easyarmorstands.command.value.YawCommand;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.lib.cloud.Command;
import me.m56738.easyarmorstands.lib.cloud.CommandManager;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.ClickEvent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.HoverEventSource;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.property.TrackedPropertyContainer;

public final class PropertyCommands {
    private PropertyCommands() {
    }

    public static void register(CommandManager<EasCommandSender> commandManager) {
        PropertyCommands.register(commandManager, new PositionCommand());
        PropertyCommands.register(commandManager, new YawCommand());
        PropertyCommands.register(commandManager, new PitchCommand());
    }

    public static <T> void register(CommandManager<EasCommandSender> commandManager, ValueCommand<T> valueCommand) {
        Permission permission = valueCommand.getPermission();
        Command.Builder<EasCommandSender> builder = commandManager.commandBuilder("eas", new String[0]).apply(valueCommand);
        commandManager.command(builder.permission(permission).commandDescription(valueCommand.getShowDescription()).apply(new ElementRequirement()).handler(context -> {
            Element element = context.get(ElementProcessor.elementKey());
            PropertyContainer properties = element.getProperties();
            if (!valueCommand.isSupported(properties)) {
                valueCommand.sendNotSupported((Audience)context.sender());
                return;
            }
            Object value = valueCommand.getValue(properties);
            ((EasCommandSender)context.sender()).sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Message.title(valueCommand.getDisplayName()))).append((Component)Component.space())).append(valueCommand.formatValue(value))).append((Component)Component.space())).append(Message.chatButton("easyarmorstands.button.edit").hoverEvent((HoverEventSource)Message.hover("easyarmorstands.click-to-edit")).clickEvent(ClickEvent.suggestCommand(valueCommand.formatCommand(value)))));
        }));
        commandManager.command(builder.permission(permission).commandDescription(valueCommand.getSetterDescription()).apply(new ElementRequirement()).required("value", valueCommand.getParser()).senderType(EasPlayer.class).handler(context -> {
            Element element = context.get(ElementProcessor.elementKey());
            TrackedPropertyContainer properties = new TrackedPropertyContainer(element, (ChangeContext)context.sender());
            if (!valueCommand.isSupported(properties)) {
                valueCommand.sendNotSupported((Audience)context.sender());
                return;
            }
            Object value = context.get("value");
            if (valueCommand.setValue(properties, value)) {
                valueCommand.sendSuccess((Audience)context.sender(), value);
            } else {
                valueCommand.sendFailure((Audience)context.sender(), value);
            }
            properties.commit();
        }));
    }
}

