/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import me.m56738.easyarmorstands.api.util.EasConversion;
import me.m56738.easyarmorstands.api.util.EasMath;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public final class EasFormat {
    public static final NumberFormat POSITION_FORMAT = new DecimalFormat("0.0000");
    public static final NumberFormat ANGLE_FORMAT = new DecimalFormat("+0.00\u00b0;-0.00\u00b0");
    public static final NumberFormat SCALE_FORMAT = new DecimalFormat("0.0000");

    private EasFormat() {
    }

    @NotNull
    private static Component format3D(@NotNull Vector3dc vector, @NotNull NumberFormat format) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(format.format(vector.x()), (TextColor)NamedTextColor.RED))).append((Component)Component.text(", "))).append((Component)Component.text(format.format(vector.y()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(", "))).append((Component)Component.text(format.format(vector.z()), (TextColor)NamedTextColor.BLUE))).build();
    }

    @NotNull
    public static Component formatPosition(@NotNull Vector3dc position) {
        return EasFormat.format3D(position, POSITION_FORMAT);
    }

    @NotNull
    public static Component formatLocation(@NotNull Location location) {
        return EasFormat.formatPosition(EasConversion.fromBukkit(location.toVector()));
    }

    @NotNull
    public static Component formatDegrees(double degrees) {
        return Component.text(ANGLE_FORMAT.format(EasMath.wrapDegrees(degrees)));
    }

    @NotNull
    public static Component formatScale(double scale) {
        return Component.text(SCALE_FORMAT.format(scale));
    }
}

