/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.lib.joml.Quaternionf;
import me.m56738.easyarmorstands.lib.joml.Quaternionfc;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;

public class JOMLMapper {
    private final Class<?> vectorClass;
    private final MethodHandle vectorConstructor;
    private final MethodHandle vectorXGetter;
    private final MethodHandle vectorYGetter;
    private final MethodHandle vectorZGetter;
    private final MethodHandle quaternionConstructor;
    private final MethodHandle quaternionXGetter;
    private final MethodHandle quaternionYGetter;
    private final MethodHandle quaternionZGetter;
    private final MethodHandle quaternionWGetter;
    private final MethodHandle transformationConstructor;
    private final MethodHandle transformationTranslationGetter;
    private final MethodHandle transformationLeftRotationGetter;
    private final MethodHandle transformationScaleGetter;
    private final MethodHandle transformationRightRotationGetter;

    public JOMLMapper() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        String joml = String.join((CharSequence)".", "org", "joml");
        Class<?> transformationClass = Class.forName("org.bukkit.util.Transformation");
        this.vectorClass = Class.forName(joml + ".Vector3f");
        Class<?> quaternionClass = Class.forName(joml + ".Quaternionf");
        this.vectorConstructor = lookup.findConstructor(this.vectorClass, MethodType.methodType(Void.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
        this.vectorXGetter = lookup.findGetter(this.vectorClass, "x", Float.TYPE);
        this.vectorYGetter = lookup.findGetter(this.vectorClass, "y", Float.TYPE);
        this.vectorZGetter = lookup.findGetter(this.vectorClass, "z", Float.TYPE);
        this.quaternionConstructor = lookup.findConstructor(quaternionClass, MethodType.methodType(Void.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
        this.quaternionXGetter = lookup.findGetter(quaternionClass, "x", Float.TYPE);
        this.quaternionYGetter = lookup.findGetter(quaternionClass, "y", Float.TYPE);
        this.quaternionZGetter = lookup.findGetter(quaternionClass, "z", Float.TYPE);
        this.quaternionWGetter = lookup.findGetter(quaternionClass, "w", Float.TYPE);
        this.transformationConstructor = lookup.findConstructor(transformationClass, MethodType.methodType(Void.TYPE, this.vectorClass, quaternionClass, this.vectorClass, quaternionClass));
        this.transformationTranslationGetter = lookup.findVirtual(transformationClass, "getTranslation", MethodType.methodType(this.vectorClass));
        this.transformationLeftRotationGetter = lookup.findVirtual(transformationClass, "getLeftRotation", MethodType.methodType(quaternionClass));
        this.transformationScaleGetter = lookup.findVirtual(transformationClass, "getScale", MethodType.methodType(this.vectorClass));
        this.transformationRightRotationGetter = lookup.findVirtual(transformationClass, "getRightRotation", MethodType.methodType(quaternionClass));
    }

    public Class<?> getNativeVectorClass() {
        return this.vectorClass;
    }

    public Object convertToNative(Vector3fc vector) {
        try {
            return this.vectorConstructor.invoke(vector.x(), vector.y(), vector.z());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Vector3f convertFromNativeVector(Object vector) {
        try {
            return new Vector3f(this.vectorXGetter.invoke(vector), this.vectorYGetter.invoke(vector), this.vectorZGetter.invoke(vector));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertToNative(Quaternionfc quaternion) {
        try {
            return this.quaternionConstructor.invoke(quaternion.x(), quaternion.y(), quaternion.z(), quaternion.w());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Quaternionf convertFromNativeQuaternion(Object quaternion) {
        try {
            return new Quaternionf(this.quaternionXGetter.invoke(quaternion), this.quaternionYGetter.invoke(quaternion), this.quaternionZGetter.invoke(quaternion), this.quaternionWGetter.invoke(quaternion));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Vector3f getTranslation(Object transformation) {
        try {
            return this.convertFromNativeVector(this.transformationTranslationGetter.invoke(transformation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Quaternionf getLeftRotation(Object transformation) {
        try {
            return this.convertFromNativeQuaternion(this.transformationLeftRotationGetter.invoke(transformation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Vector3f getScale(Object transformation) {
        try {
            return this.convertFromNativeVector(this.transformationScaleGetter.invoke(transformation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Quaternionf getRightRotation(Object transformation) {
        try {
            return this.convertFromNativeQuaternion(this.transformationRightRotationGetter.invoke(transformation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Object getTransformation(Vector3fc translation, Quaternionfc leftRotation, Vector3fc scale, Quaternionfc rightRotation) {
        try {
            return this.transformationConstructor.invoke(this.convertToNative(translation), this.convertToNative(leftRotation), this.convertToNative(scale), this.convertToNative(rightRotation));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

