/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.node.ElementSelectionNode;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.capability.equipment.EquipmentCapability;
import me.m56738.easyarmorstands.capability.handswap.SwapHandItemsListener;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.history.action.ElementCreateAction;
import me.m56738.easyarmorstands.history.action.ElementDestroyAction;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.session.SessionManagerImpl;
import me.m56738.easyarmorstands.session.context.ClickContextImpl;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SessionListener
implements Listener,
SwapHandItemsListener {
    private final EasyArmorStandsPlugin plugin;
    private final SessionManagerImpl manager;
    private final Map<Player, Integer> suppressClick = new HashMap<Player, Integer>();
    private final Map<Player, Integer> suppressArmSwing = new HashMap<Player, Integer>();

    public SessionListener(EasyArmorStandsPlugin plugin, SessionManagerImpl manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    private boolean isHoldingTool(Player player) {
        if (!player.hasPermission("easyarmorstands.edit")) {
            return false;
        }
        EquipmentCapability equipmentCapability = this.plugin.getCapability(EquipmentCapability.class);
        EntityEquipment equipment = player.getEquipment();
        for (EquipmentSlot hand : equipmentCapability.getHands()) {
            ItemStack item = equipmentCapability.getItem(equipment, hand);
            if (!this.plugin.isTool(item)) continue;
            return true;
        }
        return false;
    }

    public boolean handleLeftClick(Player player, Entity entity, Block block) {
        SessionImpl session = this.manager.getSession(player);
        if (session == null) {
            return false;
        }
        if (!this.suppressClick.containsKey(player)) {
            session.handleClick(new ClickContextImpl(session.eyeRay(), ClickContext.Type.LEFT_CLICK, entity, block));
        }
        return true;
    }

    public boolean handleLeftClick(Player player) {
        return this.handleLeftClick(player, null, null);
    }

    public boolean handleLeftClick(Player player, Block block) {
        return this.handleLeftClick(player, null, block);
    }

    public boolean handleLeftClick(Player player, Entity entity) {
        return this.handleLeftClick(player, entity, null);
    }

    private boolean handleRightClick(Player player, Entity entity, Block block) {
        SessionImpl session = this.manager.getSession(player);
        if (session != null) {
            if (!this.suppressClick.containsKey(player)) {
                session.handleClick(new ClickContextImpl(session.eyeRay(), ClickContext.Type.RIGHT_CLICK, entity, block));
            }
            return true;
        }
        if (!this.isHoldingTool(player)) {
            return false;
        }
        session = this.manager.startSession(player);
        session.setToolRequired(true);
        return true;
    }

    public boolean handleRightClick(Player player) {
        return this.handleRightClick(player, null, null);
    }

    public boolean handleRightClick(Player player, Block block) {
        return this.handleRightClick(player, null, block);
    }

    public boolean handleRightClick(Player player, Entity entity) {
        return this.handleRightClick(player, entity, null);
    }

    @Override
    public boolean handleSwap(Player player) {
        SessionImpl session = this.manager.getSession(player);
        if (session == null) {
            return false;
        }
        session.handleClick(new ClickContextImpl(session.eyeRay(), ClickContext.Type.SWAP_HANDS, null, null));
        return true;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        this.suppressArmSwing.put(event.getPlayer(), 5);
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.LEFT_CLICK_AIR && action != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (this.handleLeftClick(event.getPlayer(), event.getClickedBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeftClick(EntityDamageByEntityEvent event) {
        Entity attacker = event.getDamager();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        Entity entity = event.getEntity();
        if (this.handleLeftClick(player, entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeftClick(PlayerAnimationEvent event) {
        PlayerAnimationType type = event.getAnimationType();
        if (type != PlayerAnimationType.ARM_SWING) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!this.suppressArmSwing.containsKey(event.getPlayer())) {
                this.handleLeftClick(event.getPlayer());
            }
        });
    }

    public void updateHeldItem(Player player) {
        SessionImpl session = this.manager.getSession(player);
        if (session != null) {
            this.updateHeldItem(session);
        } else if (this.isHoldingTool(player)) {
            session = this.manager.startSession(player);
            session.setToolRequired(true);
        }
    }

    public void updateHeldItem(SessionImpl session) {
        Player player = session.player();
        if (session.isToolRequired() && !this.isHoldingTool(player)) {
            this.manager.stopSession(player);
        }
    }

    @EventHandler
    public void onHoldItem(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateHeldItem(player));
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateHeldItem(player));
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        HumanEntity player = event.getPlayer();
        if (!(player instanceof Player)) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateHeldItem((Player)player));
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.handleRightClick(event.getPlayer(), event.getClickedBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        if (this.handleRightClick(player, entity = event.getRightClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRightClickAtEntity(PlayerInteractAtEntityEvent event) {
        this.onRightClick((PlayerInteractEntityEvent)event);
    }

    public void onPlaceEntity(Player player, Entity entity) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            EasPlayer context = new EasPlayer(player);
            Element element = this.plugin.entityElementProviderRegistry().getElement(entity);
            if (element != null) {
                context.history().push(new ElementCreateAction(element));
                context.clipboard().handleAutoApply(element, context);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDestroyEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (!(damager instanceof Player)) {
            return;
        }
        Player player = (Player)damager;
        Entity entity = event.getEntity();
        Element element = this.plugin.entityElementProviderRegistry().getElement(entity);
        if (element == null) {
            return;
        }
        ElementDestroyAction action = new ElementDestroyAction(element);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (entity.isDead()) {
                this.plugin.getHistory(player).push(action);
            }
        });
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        ElementSelectionNode node;
        Player player = event.getPlayer();
        this.suppressClick.put(player, 5);
        this.suppressArmSwing.put(event.getPlayer(), 5);
        SessionImpl session = this.manager.getSession(player);
        if (session != null && (node = session.findNode(ElementSelectionNode.class)) != null && node != session.getNode()) {
            session.returnToNode(node);
            event.setCancelled(true);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateHeldItem(player));
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        if (this.plugin.isTool(event.getFuel())) {
            event.setBurnTime(0);
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        for (ItemStack item : event.getInventory().getMatrix()) {
            if (!this.plugin.isTool(item)) continue;
            event.getInventory().setResult(null);
            break;
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.manager.hideSkeletons(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.manager.stopSession(event.getPlayer());
        this.suppressClick.remove(event.getPlayer());
        this.suppressArmSwing.remove(event.getPlayer());
    }

    public void update() {
        this.expireEntries(this.suppressClick);
        this.expireEntries(this.suppressArmSwing);
        for (SessionImpl session : new ArrayList<SessionImpl>(this.manager.getAllSessions())) {
            this.updateHeldItem(session);
        }
    }

    private void expireEntries(Map<Player, Integer> map) {
        Iterator<Map.Entry<Player, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, Integer> entry = iterator.next();
            int value = entry.getValue();
            if (value > 0) {
                entry.setValue(value - 1);
                continue;
            }
            iterator.remove();
        }
    }
}

