/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.entity;

import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityLocationProperty
implements Property<Location> {
    private static final double HEIGHT_LIMIT = 2.0E7;
    private static final double COORDINATE_LIMIT = 3.0E7;
    private final Entity entity;

    public EntityLocationProperty(Entity entity) {
        this.entity = entity;
    }

    @Override
    @NotNull
    public PropertyType<Location> getType() {
        return EntityPropertyTypes.LOCATION;
    }

    @Override
    @NotNull
    public Location getValue() {
        return this.entity.getLocation();
    }

    @Override
    @Nullable
    public PendingChange prepareChange(@NotNull Location value) {
        if (!this.isValid(value)) {
            return null;
        }
        return Property.super.prepareChange(value);
    }

    @Override
    public boolean setValue(@NotNull Location value) {
        if (!this.isValid(value)) {
            return false;
        }
        boolean ok = this.entity.teleport(value);
        if (ok) {
            this.entity.setFallDistance(0.0f);
        }
        return ok;
    }

    private boolean isValid(@NotNull Location location) {
        return this.isValid(location.getX(), 3.0E7) && this.isValid(location.getY(), 2.0E7) && this.isValid(location.getZ(), 3.0E7);
    }

    private boolean isValid(double value, double limit) {
        return this.isValid(value, -limit, limit);
    }

    private boolean isValid(double value, double min, double max) {
        return value >= min && value < max;
    }
}

