/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.m56738.easyarmorstands.config.EasConfig;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.MiniMessage;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.Tag;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.m56738.easyarmorstands.lib.kyori.adventure.translation.GlobalTranslator;
import me.m56738.easyarmorstands.lib.kyori.adventure.translation.Translator;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.message.MessageMigrator;
import me.m56738.easyarmorstands.message.MessageStyle;
import me.m56738.easyarmorstands.message.PatternTranslationStore;
import org.bukkit.plugin.Plugin;

public class MessageManager {
    private static final Pattern PATTERN = Pattern.compile("(.+)\\.json");
    private static final Key key = Key.key("easyarmorstands", "translation");
    private final Plugin plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final Map<MessageStyle, String> styleTemplates = new HashMap<MessageStyle, String>();
    private final Set<Locale> loadedLocales = new HashSet<Locale>();
    private PatternTranslationStore registry = new PatternTranslationStore(key);

    public MessageManager(Plugin plugin) {
        this.plugin = plugin;
        Message.messageManager = this;
    }

    public void load(EasConfig config) {
        Stream<Path> paths2;
        this.styleTemplates.putAll(config.message.format);
        GlobalTranslator.translator().removeSource(this.registry);
        this.registry = new PatternTranslationStore(key);
        this.loadedLocales.clear();
        Path dataPath = this.plugin.getDataFolder().toPath();
        Path langPath = dataPath.resolve("lang");
        try {
            paths2 = Files.list(dataPath);
            try {
                paths2.forEach(path -> {
                    try {
                        if (MessageMigrator.migrate(path, langPath)) {
                            this.plugin.getLogger().info("Migrated custom messages: " + path.getFileName().toString());
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to convert old message file: " + path.getFileName().toString(), e);
                    }
                });
            }
            finally {
                if (paths2 != null) {
                    paths2.close();
                }
            }
        }
        catch (NoSuchFileException paths2) {
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to convert old message files", e);
        }
        try {
            paths2 = Files.list(langPath);
            try {
                paths2.forEach(this::load);
            }
            finally {
                if (paths2 != null) {
                    paths2.close();
                }
            }
        }
        catch (NoSuchFileException paths3) {
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load messages", e);
        }
        try {
            this.loadDefaultLocale(Locale.US);
            this.loadDefaultLocale(Locale.GERMANY);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load default messages", e);
        }
        if (config.message.serverSideTranslation) {
            GlobalTranslator.translator().addSource(this.registry);
        }
    }

    private void loadDefaultLocale(Locale locale) throws IOException {
        if (this.loadedLocales.add(locale)) {
            String name = "/assets/easyarmorstands/lang/" + locale.toString().toLowerCase(Locale.ROOT) + ".json";
            InputStream resource = this.getClass().getResourceAsStream(name);
            if (resource != null) {
                this.registry.readLocale(resource, locale);
            } else {
                this.plugin.getLogger().warning("Default messages for locale " + locale + " are missing: " + name);
            }
        }
    }

    private void load(Path path) {
        Matcher matcher = PATTERN.matcher(path.getFileName().toString());
        if (!matcher.matches()) {
            return;
        }
        Locale locale = Translator.parseLocale(matcher.group(1));
        if (locale == null) {
            this.plugin.getLogger().warning("Invalid locale: " + matcher.group(1));
            return;
        }
        if (!this.loadedLocales.add(locale)) {
            return;
        }
        try {
            this.registry.readLocale(path, locale);
            this.plugin.getLogger().info("Loaded custom messages for language: " + locale);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load translations from " + path.getFileName(), e);
        }
    }

    public Component format(MessageStyle style, Component message) {
        return this.format(style, message, TagResolver.empty());
    }

    public Component format(MessageStyle style, Component message, TagResolver resolver) {
        return this.miniMessage.deserialize(this.styleTemplates.get((Object)style), TagResolver.builder().tag("message", Tag.selfClosingInserting(message)).resolver(resolver).build());
    }
}

