/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu.factory;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuContext;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.api.menu.MenuSlotFactory;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.minimessage.MiniMessage;
import me.m56738.easyarmorstands.menu.MenuImpl;

class MenuFactoryImpl
implements MenuFactory {
    private final String titleTemplate;
    private final MenuSlotFactory[] slotFactories;
    private final MenuSlotFactory background;

    MenuFactoryImpl(String titleTemplate, MenuSlotFactory[] slots, MenuSlotFactory background) {
        this.titleTemplate = titleTemplate;
        this.slotFactories = slots;
        this.background = background;
    }

    @Override
    public Menu createMenu(MenuContext context) {
        MenuSlot[] slots = new MenuSlot[this.slotFactories.length];
        for (int i = 0; i < slots.length; ++i) {
            MenuSlotFactory factory = this.slotFactories[i];
            if (factory == null) continue;
            slots[i] = factory.createSlot(context);
        }
        MenuSlot backgroundSlot = this.getBackground().createSlot(context);
        for (int i = 0; i < slots.length; ++i) {
            if (slots[i] != null) continue;
            slots[i] = backgroundSlot;
        }
        return new MenuImpl(MiniMessage.miniMessage().deserialize(this.titleTemplate, context.resolver()), slots, context.locale());
    }

    private MenuSlotFactory getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return EasyArmorStandsPlugin.getInstance().getConfiguration().editor.menu.background;
    }
}

