/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.cube;

import me.m56738.easyarmorstands.lib.gizmo.AbstractLineGizmo;
import me.m56738.easyarmorstands.lib.gizmo.api.GizmoAxis;
import me.m56738.easyarmorstands.lib.gizmo.api.color.GizmoColor;
import me.m56738.easyarmorstands.lib.gizmo.cube.CubeGizmo;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class CubeLineGizmo
extends AbstractLineGizmo {
    private final CubeGizmo cube;

    public CubeLineGizmo(CubeGizmo cube) {
        this.cube = cube;
    }

    @Override
    public void show() {
        this.updateCube();
        this.cube.show();
    }

    @Override
    public void update() {
        this.updateCube();
        this.cube.update();
    }

    @Override
    public void hide() {
        this.cube.hide();
    }

    private void updateCube() {
        if (!this.checkAndClearDirty()) {
            return;
        }
        GizmoAxis axis = this.getAxis();
        double length = this.getLength();
        double width = this.getWidth();
        Vector3dc position = this.getPosition();
        Vector3dc offset = this.getOffset();
        Quaterniondc rotation = this.getRotation();
        GizmoColor color = this.getColor();
        Vector3d translation = new Vector3d(-width / 2.0);
        axis.setValue(translation, 0.0);
        translation.rotate(rotation);
        translation.add(offset);
        Vector3d scale = new Vector3d(width);
        axis.setValue(scale, length);
        this.cube.setPosition(position);
        this.cube.setOffset(translation);
        this.cube.setRotation(rotation);
        this.cube.setScale(scale);
        this.cube.setColor(color);
    }
}

