/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.setting;

import java.util.EnumSet;
import me.m56738.easyarmorstands.lib.cloud.setting.Configurable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;

final class EnumConfigurable<S extends Enum<S>>
implements Configurable<S> {
    private final EnumSet<S> settings;

    EnumConfigurable(@NonNull Class<S> settingClass) {
        this.settings = EnumSet.noneOf(settingClass);
    }

    EnumConfigurable(@NonNull S defaultSetting) {
        this.settings = EnumSet.of(defaultSetting);
    }

    @Override
    public @This @NonNull EnumConfigurable<S> set(@NonNull S setting, boolean value) {
        if (value) {
            this.settings.add(setting);
        } else {
            this.settings.remove(setting);
        }
        return this;
    }

    @Override
    public boolean get(@NonNull S setting) {
        return this.settings.contains(setting);
    }
}

