/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.tool;

import java.util.ArrayList;
import java.util.List;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.group.tool.GroupToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupMoveTool
implements MoveTool {
    private final ToolContext context;
    private final List<MoveTool> tools;

    public GroupMoveTool(ToolContext context, List<MoveTool> tools) {
        this.context = context;
        this.tools = new ArrayList<MoveTool>(tools);
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public MoveToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        for (MoveTool tool : this.tools) {
            if (!tool.canUse(player)) continue;
            return true;
        }
        return false;
    }

    private class SessionImpl
    extends GroupToolSession<MoveToolSession>
    implements MoveToolSession {
        private final Vector3dc originalPosition;
        private final Vector3d offset;

        private SessionImpl() {
            super(GroupMoveTool.this.tools);
            this.offset = new Vector3d();
            this.originalPosition = new Vector3d(GroupMoveTool.this.context.position().getPosition());
        }

        @Override
        public void setChange(@NotNull Vector3dc change) {
            this.offset.set(change);
            for (MoveToolSession session : this.sessions) {
                session.setChange(change);
            }
        }

        @Override
        public void snapChange(@NotNull Vector3d change, @NotNull Snapper context) {
            context.snapOffset(change);
        }

        @Override
        @NotNull
        public Vector3dc getPosition() {
            return this.originalPosition.add(this.offset, new Vector3d());
        }

        @Override
        public void setPosition(@NotNull Vector3dc position) {
            position.sub(this.originalPosition, this.offset);
            this.setChange(this.offset);
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Util.formatOffset(this.offset);
        }

        @Override
        @Nullable
        public Component getDescription() {
            TextComponent count = Component.text(this.sessions.size());
            Component value = Util.formatOffset(this.offset);
            return Message.component("easyarmorstands.history.group.move", count, value);
        }
    }
}

