/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.AddContext;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.RemoveContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.MenuNode;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuMode;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.GroupMember;
import me.m56738.easyarmorstands.group.tool.GroupToolProvider;
import org.jetbrains.annotations.NotNull;

public class GroupRootNode
extends MenuNode {
    private final Session session;
    private final Group group;
    private final BoundingBoxParticle boxParticle;
    private final ToolMenuManager toolManager;

    public GroupRootNode(Group group) {
        super(group.getSession());
        this.session = group.getSession();
        this.group = group;
        this.boxParticle = this.session.particleProvider().createAxisAlignedBox();
        this.boxParticle.setColor(ParticleColor.GRAY);
        this.toolManager = new ToolMenuManager(this.session, this, new GroupToolProvider(group));
    }

    private void updateBox() {
        BoundingBox box = null;
        for (GroupMember member : this.group.getMembers()) {
            BoundingBox boundingBox = member.getBoundingBox();
            if (box == null) {
                box = boundingBox;
                continue;
            }
            box = BoundingBox.of(box, boundingBox);
        }
        if (box != null) {
            this.boxParticle.setBoundingBox(box);
        }
    }

    @Override
    public void onAdd(@NotNull AddContext context) {
        super.onAdd(context);
        this.updateBox();
        this.session.addParticle(this.boxParticle);
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        super.onEnter(context);
        this.boxParticle.setColor(ParticleColor.WHITE);
        this.toolManager.setMode(ToolMenuMode.GLOBAL);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        super.onUpdate(context);
        this.group.update();
        this.updateBox();
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        this.boxParticle.setColor(ParticleColor.GRAY);
        super.onExit(context);
    }

    @Override
    public void onInactiveUpdate(@NotNull UpdateContext context) {
        super.onInactiveUpdate(context);
        this.group.update();
        this.updateBox();
    }

    @Override
    public void onRemove(@NotNull RemoveContext context) {
        this.session.removeParticle(this.boxParticle);
        super.onRemove(context);
    }

    @Override
    public boolean isValid() {
        return this.group.isValid();
    }

    public Group getGroup() {
        return this.group;
    }
}

