/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.fancyholograms;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramManager;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.addon.Addon;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.fancyholograms.FancyHologramsListener;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElementDiscoverySource;
import me.m56738.easyarmorstands.fancyholograms.element.HologramElementType;
import me.m56738.easyarmorstands.fancyholograms.property.type.HologramDataPropertyType;
import me.m56738.easyarmorstands.fancyholograms.property.type.TextHologramTextPropertyType;
import me.m56738.easyarmorstands.util.JOMLMapper;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FancyHologramsAddon
implements Addon {
    private final EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
    private FancyHologramsListener listener;
    private MenuFactory itemMenuFactory;
    private MenuFactory blockMenuFactory;
    private MenuFactory textMenuFactory;

    @Override
    public String name() {
        return "FancyHolograms";
    }

    @Override
    public void enable() {
        JOMLMapper mapper;
        this.load();
        EasyArmorStandsPlugin.getInstance().propertyTypeRegistry().register(HologramDataPropertyType.INSTANCE);
        EasyArmorStandsPlugin.getInstance().propertyTypeRegistry().register(TextHologramTextPropertyType.INSTANCE);
        try {
            mapper = new JOMLMapper();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
        HologramElementType type = new HologramElementType(manager, mapper, this);
        HologramElementDiscoverySource discoverySource = new HologramElementDiscoverySource(type, manager);
        this.listener = new FancyHologramsListener(discoverySource);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this.listener);
        this.listener = null;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.itemMenuFactory = this.plugin.loadMenuTemplate("fancyholograms/item");
        this.blockMenuFactory = this.plugin.loadMenuTemplate("fancyholograms/block");
        this.textMenuFactory = this.plugin.loadMenuTemplate("fancyholograms/text");
    }

    public MenuFactory getMenuFactory(HologramData data) {
        if (data instanceof ItemHologramData) {
            return this.itemMenuFactory;
        }
        if (data instanceof BlockHologramData) {
            return this.blockMenuFactory;
        }
        if (data instanceof TextHologramData) {
            return this.textMenuFactory;
        }
        return null;
    }
}

