/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.element;

import java.util.Objects;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.BoundingBoxButton;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.element.ConfigurableEntityElement;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.element.EditableElement;
import me.m56738.easyarmorstands.api.element.MenuElement;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.PropertyRegistry;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.capability.entityscale.EntityScaleCapability;
import me.m56738.easyarmorstands.capability.entitysize.EntitySizeCapability;
import me.m56738.easyarmorstands.editor.EntityPositionProvider;
import me.m56738.easyarmorstands.editor.node.SimpleEntityNode;
import me.m56738.easyarmorstands.element.SimpleEntityElementType;
import me.m56738.easyarmorstands.element.SimpleEntityToolProvider;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.permission.Permissions;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SimpleEntityElement<E extends Entity>
implements ConfigurableEntityElement<E>,
SelectableElement,
MenuElement,
DestroyableElement,
EditableElement {
    private final E entity;
    private final SimpleEntityElementType<E> type;
    private final PropertyRegistry properties = PropertyRegistry.create(this);
    private final EntitySizeCapability sizeCapability;
    private final EntityScaleCapability scaleCapability;

    public SimpleEntityElement(E entity, SimpleEntityElementType<E> type) {
        this.entity = entity;
        this.type = type;
        this.sizeCapability = EasyArmorStandsPlugin.getInstance().getCapability(EntitySizeCapability.class);
        this.scaleCapability = EasyArmorStandsPlugin.getInstance().getCapability(EntityScaleCapability.class);
    }

    @Override
    @NotNull
    public E getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public SimpleEntityElementType<E> getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.entity.isValid();
    }

    @Override
    @NotNull
    public PropertyRegistry getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public ToolProvider getTools(@NotNull PropertyContainer properties) {
        return new SimpleEntityToolProvider(properties);
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        Vector3d position = Util.toVector3d(this.entity.getLocation());
        if (this.sizeCapability == null) {
            return BoundingBox.of((Vector3dc)position);
        }
        double width = this.sizeCapability.getWidth((Entity)this.entity);
        double height = this.sizeCapability.getHeight((Entity)this.entity);
        return BoundingBox.of((Vector3dc)position, width, height);
    }

    public double getScale() {
        if (this.scaleCapability != null && this.entity instanceof LivingEntity) {
            return this.scaleCapability.getEffectiveScale((LivingEntity)this.entity);
        }
        return 1.0;
    }

    @Override
    @NotNull
    public Button createButton(@NotNull Session session) {
        return new BoundingBoxButton(session, this, new EntityPositionProvider(this.properties), RotationProvider.identity());
    }

    @Override
    @NotNull
    public Node createNode(@NotNull Session session) {
        return new SimpleEntityNode(session, this);
    }

    @Override
    public void openMenu(@NotNull Player player) {
        SessionImpl session = EasyArmorStandsPlugin.getInstance().sessionManager().getSession(player);
        EasyArmorStandsPlugin.getInstance().openEntityMenu(player, session, this);
    }

    @Override
    public void destroy() {
        this.entity.remove();
    }

    @Override
    public boolean canEdit(@NotNull Player player) {
        return player.hasPermission(Permissions.entityType("easyarmorstands.edit", this.type.getEntityType()));
    }

    @Override
    public boolean canDestroy(@NotNull Player player) {
        return player.hasPermission(Permissions.entityType("easyarmorstands.destroy", this.type.getEntityType()));
    }

    @Override
    @NotNull
    public Component getName() {
        return Component.text(Util.getId(this.entity.getUniqueId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleEntityElement that = (SimpleEntityElement)o;
        return Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.entity);
    }
}

