/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuMode;
import me.m56738.easyarmorstands.capability.handswap.SwapHandItemsCapability;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentBuilder;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.message.Message;

public class ToolMenuModeSwitcher {
    private final ToolMenuManager toolManager;
    private final SwapHandItemsCapability swapHandItemsCapability = EasyArmorStandsPlugin.getInstance().getCapability(SwapHandItemsCapability.class);

    public ToolMenuModeSwitcher(ToolMenuManager toolManager) {
        this.toolManager = toolManager;
    }

    public Component getActionBar() {
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(this.toolManager.getMode().getName());
        if (this.swapHandItemsCapability != null) {
            Component swapHandsButton = this.swapHandItemsCapability.key();
            builder.append((ComponentBuilder<?, ?>)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().appendSpace()).append((Component)Component.text('['))).append(swapHandsButton)).append((Component)Component.text(']'))).appendSpace()).append(Message.component("easyarmorstands.node.switch-mode"))).color(NamedTextColor.GRAY));
        }
        return builder.build();
    }

    public boolean onClick(ClickContext context) {
        if (context.type() == ClickContext.Type.SWAP_HANDS) {
            return this.switchMode();
        }
        if (this.swapHandItemsCapability == null && context.type() == ClickContext.Type.RIGHT_CLICK) {
            return this.switchMode();
        }
        return false;
    }

    private boolean switchMode() {
        ToolMenuMode mode = this.toolManager.getMode();
        ToolMenuMode nextMode = this.toolManager.getNextMode();
        if (nextMode != mode) {
            this.toolManager.setMode(nextMode);
            return true;
        }
        return false;
    }
}

