/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementSelectionNode;
import me.m56738.easyarmorstands.api.editor.node.MenuNode;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.element.ElementDiscoveryEntry;
import me.m56738.easyarmorstands.api.element.ElementDiscoverySource;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.editor.node.EntityElementDiscoverySource;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.message.MessageStyle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ElementSelectionNodeImpl
extends MenuNode
implements ElementSelectionNode {
    private final Session session;
    private final Map<ElementDiscoveryEntry, ElementEntry> entries = new HashMap<ElementDiscoveryEntry, ElementEntry>();
    private final Component name;
    private final Set<ElementDiscoverySource> sources = new LinkedHashSet<ElementDiscoverySource>();
    private final Map<ElementDiscoveryEntry, SelectableElement> groupMembers = new LinkedHashMap<ElementDiscoveryEntry, SelectableElement>();
    private final Map<ElementDiscoveryEntry, SelectableElement> selectionBoxMembers = new LinkedHashMap<ElementDiscoveryEntry, SelectableElement>();
    private final Vector3d selectionBoxOrigin = new Vector3d();
    private final double selectionCursorOffset = 2.0;
    private final BoundingBoxParticle selectionBoxParticle;
    private BoundingBox selectionBox;
    private boolean selectionBoxEditing;
    private double range;
    private double boxSizeLimit;
    private int buttonLimit;
    private int groupLimit;
    private int buttonCount;

    public ElementSelectionNodeImpl(Session session) {
        super(session);
        this.range = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.range;
        this.boxSizeLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.group.range;
        this.buttonLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.discovery.limit;
        this.groupLimit = EasyArmorStandsPlugin.getInstance().getConfiguration().editor.selection.group.limit;
        this.session = session;
        this.name = Message.component("easyarmorstands.node.select-entity");
        this.selectionBoxParticle = session.particleProvider().createAxisAlignedBox();
    }

    @Override
    public double getRange() {
        return this.range;
    }

    @Override
    public void setRange(double range) {
        this.range = range;
    }

    @Override
    public void addSource(@NotNull ElementDiscoverySource source) {
        this.sources.add(source);
    }

    @Override
    public void removeSource(@NotNull ElementDiscoverySource source) {
        this.sources.remove(source);
    }

    @Override
    public @Unmodifiable @NotNull Iterable<ElementDiscoverySource> getSources() {
        return Collections.unmodifiableSet(new HashSet<ElementDiscoverySource>(this.sources));
    }

    private void startBoxSelection(Vector3dc origin) {
        this.selectionBoxOrigin.set(origin);
        if (this.selectionBox != null) {
            this.session.removeParticle(this.selectionBoxParticle);
        }
        this.selectionBox = BoundingBox.of((Vector3dc)this.selectionBoxOrigin);
        this.selectionBoxParticle.setBoundingBox(this.selectionBox);
        this.selectionBoxParticle.setColor(ParticleColor.YELLOW);
        this.selectionBoxEditing = true;
        this.session.addParticle(this.selectionBoxParticle);
    }

    private void finishBoxSelection() {
        this.selectionBoxEditing = false;
        this.groupMembers.putAll(this.selectionBoxMembers);
        this.selectionBoxMembers.clear();
        this.selectionBoxParticle.setColor(ParticleColor.GRAY);
    }

    private void cancelBoxSelection() {
        if (this.selectionBox == null) {
            return;
        }
        this.selectionBoxEditing = false;
        this.selectionBox = null;
        this.session.removeParticle(this.selectionBoxParticle);
        this.selectionBoxMembers.clear();
    }

    private BoundingBox getDiscoveryBox(EyeRay eyeRay) {
        Vector3dc origin = eyeRay.origin();
        Vector3d halfSize = new Vector3d(this.range);
        return BoundingBox.of((Vector3dc)origin.sub(halfSize, new Vector3d()), (Vector3dc)origin.add(halfSize, new Vector3d()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        ElementButton button;
        if (this.selectionBoxEditing) {
            Vector3dc cursor = context.eyeRay().point(2.0);
            this.selectionBox = BoundingBox.of((Vector3dc)this.selectionBoxOrigin, cursor);
            Vector3d size = this.selectionBox.getSize(new Vector3d());
            double maxSize = size.get(size.maxComponent());
            if (maxSize > this.boxSizeLimit) {
                this.cancelBoxSelection();
            }
        }
        EyeRay eyeRay = context.eyeRay();
        BoundingBox box = this.getDiscoveryBox(eyeRay);
        HashSet<ElementDiscoveryEntry> foundEntries = new HashSet<ElementDiscoveryEntry>(this.groupMembers.keySet());
        for (ElementDiscoverySource elementDiscoverySource : this.sources) {
            elementDiscoverySource.discover(eyeRay.world(), box, foundEntries::add);
        }
        Iterator<Object> iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ElementDiscoveryEntry, ElementEntry> entry = iterator.next();
            if (foundEntries.contains(entry.getKey())) continue;
            button = entry.getValue().button;
            if (button != null) {
                this.removeButton(button);
                --this.buttonCount;
            }
            iterator.remove();
        }
        for (ElementDiscoveryEntry elementDiscoveryEntry : foundEntries) {
            if (this.isButtonLimitReached()) break;
            this.entries.computeIfAbsent(elementDiscoveryEntry, this::addEntry);
        }
        if (this.selectionBox != null) {
            this.selectionBoxParticle.setBoundingBox(this.selectionBox);
            this.selectionBoxMembers.values().removeIf(e -> !e.isValid() || !e.getBoundingBox().overlaps(this.selectionBox));
            for (ElementEntry elementEntry : this.entries.values()) {
                SelectableElement element;
                button = elementEntry.button;
                if (button == null || !(element = button.element).getBoundingBox().overlaps(this.selectionBox)) continue;
                if (this.groupMembers.size() + this.selectionBoxMembers.size() >= this.groupLimit) break;
                this.selectionBoxMembers.putIfAbsent(button.entry, element);
                this.groupMembers.remove(button.entry);
            }
            if (!this.selectionBoxEditing) {
                this.groupMembers.putAll(this.selectionBoxMembers);
                this.selectionBoxMembers.clear();
            }
        }
        super.onUpdate(context);
        this.groupMembers.values().removeIf(e -> !e.isValid());
        int groupSize = this.groupMembers.size() + this.selectionBoxMembers.size();
        if (groupSize == 0) {
            if (this.isButtonLimitReached()) {
                context.setActionBar(Message.error("easyarmorstands.node.select-entity.limit-reached"));
            } else {
                context.setActionBar(this.name);
            }
        } else if (groupSize == 1) {
            context.setActionBar(Message.component("easyarmorstands.node.group-selected.single"));
        } else {
            void var6_17;
            Component component = Message.component("easyarmorstands.node.group-selected", Component.text(groupSize));
            if (groupSize >= this.groupLimit) {
                Component component2 = Message.format(MessageStyle.ERROR, component);
            }
            context.setActionBar((ComponentLike)var6_17);
        }
    }

    private boolean isButtonLimitReached() {
        return this.buttonLimit > 0 && this.buttonCount >= this.buttonLimit;
    }

    private SelectableElement getElement(ElementDiscoveryEntry entry) {
        ElementEntry elementEntry = this.entries.get(entry);
        if (elementEntry == null || elementEntry.button == null) {
            return entry.getElement();
        }
        return elementEntry.button.element;
    }

    private ElementEntry addEntry(ElementDiscoveryEntry entry) {
        SelectableElement element = entry.getElement();
        EasPlayer context = new EasPlayer(this.session.player());
        if (element == null || !context.canDiscoverElement(element)) {
            return ElementEntry.EMPTY;
        }
        ElementButton button = new ElementButton(entry, this.session, element);
        this.addButton(button);
        ++this.buttonCount;
        return new ElementEntry(button);
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        super.onExit(context);
        for (ElementEntry entry : this.entries.values()) {
            if (entry.button == null) continue;
            this.removeButton(entry.button);
        }
        this.entries.clear();
        this.buttonCount = 0;
        this.cancelBoxSelection();
    }

    private Consumer<Vector3dc> getEntityClickHandler(Entity entity) {
        for (ElementDiscoverySource source : this.sources) {
            ElementDiscoveryEntry entry;
            SelectableElement element;
            if (!(source instanceof EntityElementDiscoverySource) || (element = this.getElement(entry = ((EntityElementDiscoverySource)source).getEntry(entity))) == null) continue;
            return cursor -> this.onClickElement(entry, element, (Vector3dc)cursor);
        }
        return null;
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        Player player = this.session.player();
        if (context.type() == ClickContext.Type.RIGHT_CLICK && this.selectionBoxEditing) {
            this.finishBoxSelection();
            return true;
        }
        if (context.type() == ClickContext.Type.RIGHT_CLICK && !player.isSneaking() && !this.groupMembers.isEmpty()) {
            int groupSize = this.groupMembers.size();
            if (groupSize > 1) {
                Group group = new Group(this.session);
                for (SelectableElement element : this.groupMembers.values()) {
                    group.addMember(element);
                }
                this.session.pushNode(new GroupRootNode(group));
            } else {
                SelectableElement element = this.groupMembers.values().iterator().next();
                this.session.pushNode(element.createNode(this.session));
            }
            return true;
        }
        if (context.type() == ClickContext.Type.LEFT_CLICK) {
            if (this.selectionBox != null) {
                this.cancelBoxSelection();
                return true;
            }
            if (!this.groupMembers.isEmpty()) {
                this.groupMembers.clear();
                return true;
            }
            if (player.hasPermission("easyarmorstands.spawn")) {
                Menu menu = EasyArmorStandsPlugin.getInstance().createSpawnMenu(player);
                player.openInventory(menu.getInventory());
                return true;
            }
        }
        if (super.onClick(context)) {
            return true;
        }
        if (context.type() == ClickContext.Type.RIGHT_CLICK) {
            Consumer<Vector3dc> entityClickHandler;
            Entity entity = context.entity();
            if (entity != null && (entityClickHandler = this.getEntityClickHandler(entity)) != null) {
                entityClickHandler.accept(null);
                return true;
            }
            if (player.isSneaking() && !this.selectionBoxEditing && player.hasPermission("easyarmorstands.group")) {
                this.startBoxSelection(context.eyeRay().point(2.0));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean selectElement(@NotNull SelectableElement element) {
        EasPlayer context = new EasPlayer(this.session.player());
        if (!context.canEditElement(element)) {
            return false;
        }
        Node node = element.createNode(this.session);
        this.session.returnToNode(this);
        this.session.pushNode(node);
        return true;
    }

    @Override
    public boolean selectElements(@NotNull List<? extends SelectableElement> elements) {
        if (elements.size() == 1) {
            return this.selectElement(elements.get(0));
        }
        Group group = new Group(this.session);
        EasPlayer context = new EasPlayer(this.session.player());
        for (SelectableElement selectableElement : elements) {
            if (!context.canEditElement(selectableElement)) continue;
            group.addMember(selectableElement);
        }
        if (!group.isValid()) {
            return false;
        }
        this.session.returnToNode(this);
        this.session.pushNode(new GroupRootNode(group));
        return true;
    }

    private void onClickElement(ElementDiscoveryEntry entry, SelectableElement element, @Nullable Vector3dc cursor) {
        if (this.groupMembers.remove(entry) != null) {
            return;
        }
        EasPlayer context = new EasPlayer(this.session.player());
        if (!context.canEditElement(element)) {
            return;
        }
        if (this.session.player().isSneaking() && this.session.player().hasPermission("easyarmorstands.group")) {
            if (this.groupMembers.size() < this.groupLimit) {
                this.groupMembers.put(entry, element);
            }
            return;
        }
        Node node = element.createNode(this.session);
        this.session.pushNode(node, cursor);
    }

    private static class ElementEntry {
        private static final ElementEntry EMPTY = new ElementEntry(null);
        @Nullable
        private final ElementButton button;

        private ElementEntry(@Nullable ElementButton button) {
            this.button = button;
        }
    }

    private class ElementButton
    implements MenuButton {
        private final ElementDiscoveryEntry entry;
        private final SelectableElement element;
        private final Button button;

        private ElementButton(ElementDiscoveryEntry entry, Session session, SelectableElement element) {
            this.entry = entry;
            this.element = element;
            this.button = element.createButton(session);
        }

        @Override
        @NotNull
        public Button getButton() {
            return this.button;
        }

        @Override
        public void onClick(@NotNull Session session, @Nullable Vector3dc cursor) {
            ElementSelectionNodeImpl.this.onClickElement(this.entry, this.element, cursor);
        }

        @Override
        @NotNull
        public Component getName() {
            return this.element.getName();
        }

        @Override
        public boolean isAlwaysFocused() {
            return ElementSelectionNodeImpl.this.groupMembers.containsKey(this.entry) || ElementSelectionNodeImpl.this.selectionBoxMembers.containsKey(this.entry);
        }
    }
}

