/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.AddContext;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.RemoveContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.ElementNode;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuManager;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuMode;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.display.editor.box.InteractionBoxEditor;
import me.m56738.easyarmorstands.display.element.InteractionElement;
import me.m56738.easyarmorstands.editor.node.BoxResizeToolManager;
import me.m56738.easyarmorstands.editor.node.PropertyMenuNode;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InteractionRootNode
extends PropertyMenuNode
implements ElementNode {
    private final Session session;
    private final InteractionElement element;
    private final BoundingBoxParticle boxParticle;
    private final Property<Location> locationProperty;
    private final Property<Float> widthProperty;
    private final Property<Float> heightProperty;

    public InteractionRootNode(Session session, InteractionElement element) {
        super(session, session.properties(element));
        this.session = session;
        this.element = element;
        this.boxParticle = session.particleProvider().createAxisAlignedBox();
        this.locationProperty = this.properties().get(EntityPropertyTypes.LOCATION);
        this.widthProperty = this.properties().get(DisplayPropertyTypes.BOX_WIDTH);
        this.heightProperty = this.properties().get(DisplayPropertyTypes.BOX_HEIGHT);
        new ToolMenuManager(session, this, element.getTools(this.properties())).setMode(ToolMenuMode.GLOBAL);
        new BoxResizeToolManager(session, this, new InteractionBoxEditor(this.properties()));
    }

    @Override
    public void onAdd(@NotNull AddContext context) {
        this.boxParticle.setColor(ParticleColor.GRAY);
        this.updateBoundingBox();
        this.session.addParticle(this.boxParticle);
    }

    @Override
    public void onRemove(@NotNull RemoveContext context) {
        this.session.removeParticle(this.boxParticle);
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.boxParticle.setColor(ParticleColor.WHITE);
        this.updateBoundingBox();
        super.onEnter(context);
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        this.boxParticle.setColor(ParticleColor.GRAY);
        this.updateBoundingBox();
        super.onExit(context);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        this.updateBoundingBox();
        super.onUpdate(context);
    }

    @Override
    public void onInactiveUpdate(@NotNull UpdateContext context) {
        this.updateBoundingBox();
        super.onInactiveUpdate(context);
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        if (super.onClick(context)) {
            return true;
        }
        Player player = this.session.player();
        if (context.type() == ClickContext.Type.LEFT_CLICK && player.hasPermission("easyarmorstands.open")) {
            this.element.openMenu(player);
            return true;
        }
        return false;
    }

    private void updateBoundingBox() {
        float width = this.widthProperty.getValue().floatValue();
        float height = this.heightProperty.getValue().floatValue();
        Location location = this.locationProperty.getValue();
        Vector3d position = Util.toVector3d(location);
        this.boxParticle.setBoundingBox(BoundingBox.of((Vector3dc)position, width, height));
    }

    @Override
    @NotNull
    public InteractionElement getElement() {
        return this.element;
    }
}

