/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.node.MenuNode;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.editor.util.ToolMenuMode;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;

public class ToolMenuManager {
    private final Session session;
    private final MenuNode menuNode;
    private final ToolProvider toolProvider;
    private final List<MenuButton> buttons = new ArrayList<MenuButton>();
    private ToolMenuMode mode = null;

    public ToolMenuManager(Session session, MenuNode menuNode, ToolProvider toolProvider) {
        this.session = session;
        this.menuNode = menuNode;
        this.toolProvider = toolProvider;
        for (ToolMenuMode mode : ToolMenuMode.values()) {
            if (!this.setMode(mode)) continue;
            return;
        }
        this.setMode(ToolMenuMode.LOCAL);
    }

    public boolean hasMode(ToolMenuMode mode) {
        ArrayList<MenuButton> buttons = new ArrayList<MenuButton>();
        this.collectButtons(mode, buttons);
        return !buttons.isEmpty();
    }

    public ToolMenuMode getMode() {
        return this.mode;
    }

    public ToolMenuMode getNextMode() {
        int i;
        ToolMenuMode[] modes = ToolMenuMode.values();
        for (i = this.mode.ordinal() + 1; i < modes.length; ++i) {
            if (!this.hasMode(modes[i])) continue;
            return modes[i];
        }
        for (i = 0; i < this.mode.ordinal(); ++i) {
            if (!this.hasMode(modes[i])) continue;
            return modes[i];
        }
        return this.mode;
    }

    private ToolContext createToolContext() {
        PositionProvider positionProvider = this.toolProvider.position();
        RotationProvider rotationProvider = this.mode == ToolMenuMode.GLOBAL ? RotationProvider.identity() : this.toolProvider.rotation();
        return ToolContext.of(positionProvider, rotationProvider);
    }

    private void collectButtons(ToolMenuMode mode, List<MenuButton> buttons) {
        ToolContext context = this.createToolContext();
        if (mode == ToolMenuMode.SCALE) {
            ScaleTool scaleTool = this.toolProvider.scale(context);
            if (scaleTool != null && scaleTool.canUse(this.session.player())) {
                buttons.add(this.session.menuEntryProvider().scale().setTool(scaleTool).setPriority(1).build());
            }
            for (Axis axis : Axis.values()) {
                AxisScaleTool axisScaleTool = this.toolProvider.scale(context, axis);
                if (axisScaleTool == null || !axisScaleTool.canUse(this.session.player())) continue;
                buttons.add(this.session.menuEntryProvider().axisScale().setTool(axisScaleTool).build());
            }
            return;
        }
        MoveTool moveTool = this.toolProvider.move(context);
        if (moveTool != null && moveTool.canUse(this.session.player())) {
            buttons.add(this.session.menuEntryProvider().move().setTool(moveTool).setPriority(1).build());
        }
        for (Axis axis : Axis.values()) {
            AxisRotateTool axisRotateTool;
            AxisMoveTool axisMoveTool = this.toolProvider.move(context, axis);
            if (axisMoveTool != null && axisMoveTool.canUse(this.session.player())) {
                buttons.add(this.session.menuEntryProvider().axisMove().setTool(axisMoveTool).build());
            }
            if ((axisRotateTool = this.toolProvider.rotate(context, axis)) == null || !axisRotateTool.canUse(this.session.player())) continue;
            buttons.add(this.session.menuEntryProvider().axisRotate().setTool(axisRotateTool).build());
        }
    }

    public boolean setMode(ToolMenuMode mode) {
        this.mode = Objects.requireNonNull(mode);
        for (MenuButton button : this.buttons) {
            this.menuNode.removeButton(button);
        }
        this.buttons.clear();
        this.collectButtons(mode, this.buttons);
        for (MenuButton button : this.buttons) {
            this.menuNode.addButton(button);
        }
        return !this.buttons.isEmpty();
    }
}

