/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.button.Button;
import me.m56738.easyarmorstands.api.editor.button.ButtonResult;
import me.m56738.easyarmorstands.api.editor.button.MenuButton;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public abstract class MenuNode
implements Node {
    private final Session session;
    private final Map<MenuButton, Button> buttons = new HashMap<MenuButton, Button>();
    private MenuButton targetButton;
    private Vector3dc targetCursor;
    private boolean visible;

    public MenuNode(@NotNull Session session) {
        this.session = session;
    }

    public final void addButton(@NotNull MenuButton menuButton) {
        this.setButton(menuButton, menuButton.getButton());
    }

    public final void removeButton(@NotNull MenuButton menuButton) {
        this.setButton(Objects.requireNonNull(menuButton), null);
    }

    private void setButton(MenuButton menuButton, Button button) {
        Button oldButton = button != null ? this.buttons.put(menuButton, button) : this.buttons.remove(menuButton);
        if (this.visible) {
            if (oldButton != null) {
                oldButton.hidePreview();
            }
            if (button != null) {
                button.update();
                button.updatePreview(menuButton.isAlwaysFocused());
                button.showPreview();
            }
        }
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.targetButton = null;
        this.visible = true;
        for (Map.Entry<MenuButton, Button> entry : this.buttons.entrySet()) {
            MenuButton menuButton = entry.getKey();
            Button button = entry.getValue();
            button.update();
            button.updatePreview(menuButton.isAlwaysFocused());
            button.showPreview();
        }
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        this.targetButton = null;
        this.visible = false;
        for (Button button : this.buttons.values()) {
            button.hidePreview();
        }
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        Button button;
        MenuButton menuButton;
        EyeRay ray = context.eyeRay();
        Button bestButton = null;
        MenuButton bestMenuButton = null;
        Vector3dc bestCursor = null;
        int bestPriority = Integer.MIN_VALUE;
        double bestDistance = Double.POSITIVE_INFINITY;
        ArrayList results = new ArrayList();
        for (Map.Entry<MenuButton, Button> entry : this.buttons.entrySet()) {
            menuButton = entry.getKey();
            button = entry.getValue();
            button.update();
            button.intersect(ray, results::add);
            for (ButtonResult result : results) {
                Vector3dc position = result.position();
                int priority = result.priority();
                if (priority < bestPriority) continue;
                double distance = position.distanceSquared(ray.origin());
                if (priority <= bestPriority && !(distance < bestDistance)) continue;
                bestButton = button;
                bestMenuButton = menuButton;
                bestCursor = position;
                bestPriority = priority;
                bestDistance = distance;
            }
            results.clear();
        }
        for (Map.Entry<MenuButton, Button> entry : this.buttons.entrySet()) {
            menuButton = entry.getKey();
            button.updatePreview((button = entry.getValue()) == bestButton || menuButton.isAlwaysFocused());
        }
        Component targetName = bestButton != null ? bestMenuButton.getName() : Component.empty();
        context.setSubtitle(targetName);
        this.targetButton = bestMenuButton;
        this.targetCursor = bestCursor;
    }

    @Override
    public boolean onClick(@NotNull ClickContext context) {
        if (context.type() == ClickContext.Type.RIGHT_CLICK && this.targetButton != null) {
            this.targetButton.onClick(this.session, this.targetCursor);
            return true;
        }
        return false;
    }
}

