/*
 * Decompiled with CFR 0.152.
 */
package owny;

import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ParrotBreeder
extends JavaPlugin
implements Listener {
    private final Set<Material> seedTypes = EnumSet.of(Material.WHEAT_SEEDS, new Material[]{Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.BEETROOT_SEEDS, Material.TORCHFLOWER_SEEDS, Material.PITCHER_POD});
    private NamespacedKey cooldownKey;
    private NamespacedKey babyKey;
    private long cooldownMillis;
    private long growUpMillis;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.cooldownMillis = config.getLong("breeding-cooldown-seconds", 240L) * 1000L;
        this.growUpMillis = config.getLong("grow-up-seconds", 240L) * 1000L;
        this.cooldownKey = new NamespacedKey((Plugin)this, "breeding_cooldown");
        this.babyKey = new NamespacedKey((Plugin)this, "baby");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("ParrotBreeder enabled!");
    }

    public void onDisable() {
        this.getLogger().info("ParrotBreeder disabled.");
    }

    @EventHandler
    public void onParrotInteract(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Parrot)) {
            return;
        }
        final Parrot parrot = (Parrot)entity;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        if (!this.seedTypes.contains(item.getType())) {
            return;
        }
        final long now = System.currentTimeMillis();
        Long lastBreed = (Long)parrot.getPersistentDataContainer().get(this.cooldownKey, PersistentDataType.LONG);
        if (lastBreed != null && now - lastBreed < this.cooldownMillis) {
            event.getPlayer().sendMessage("The parrot needs to rest before breeding again.");
            return;
        }
        parrot.getPersistentDataContainer().set(this.cooldownKey, PersistentDataType.LONG, (Object)now);
        item.setAmount(item.getAmount() - 1);
        this.showHearts(parrot);
        Parrot partner = parrot.getWorld().getNearbyEntities(parrot.getLocation(), 5.0, 5.0, 5.0).stream().filter(e -> e instanceof Parrot && e != parrot).map(e -> (Parrot)e).filter(p -> {
            Long cooldown = (Long)p.getPersistentDataContainer().get(this.cooldownKey, PersistentDataType.LONG);
            return cooldown == null || now - cooldown >= this.cooldownMillis;
        }).findFirst().orElse(null);
        if (partner != null) {
            partner.getPersistentDataContainer().set(this.cooldownKey, PersistentDataType.LONG, (Object)now);
            this.showHearts(partner);
            new BukkitRunnable(this){
                final /* synthetic */ ParrotBreeder this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    final Parrot baby = (Parrot)parrot.getWorld().spawn(parrot.getLocation(), Parrot.class);
                    baby.getPersistentDataContainer().set(this.this$0.babyKey, PersistentDataType.LONG, (Object)now);
                    this.this$0.showHearts(baby);
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (!baby.isValid()) {
                                return;
                            }
                            baby.getPersistentDataContainer().remove(this.this$1.this$0.babyKey);
                            baby.getWorld().spawnParticle(Particle.HEART, baby.getLocation(), 10, 0.3, 0.5, 0.3);
                        }
                    }.runTaskLater((Plugin)this.this$0, this.this$0.growUpMillis / 50L);
                }
            }.runTaskLater((Plugin)this, 60L);
        }
    }

    private void showHearts(Parrot parrot) {
        parrot.getWorld().spawnParticle(Particle.HEART, parrot.getLocation().add(0.0, 0.5, 0.0), 8, 0.5, 0.5, 0.5);
    }
}

