/*
 * Decompiled with CFR 0.152.
 */
package com.SolanaDevMinecraft;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Store {
    private final Connection connection;
    private final FileConfiguration config;
    private static Economy economy;

    public Store(FileConfiguration config, Connection connection) {
        this.config = config;
        this.connection = connection;
    }

    public String getPlayerLanguage(Player player) {
        String locale = player.getLocale();
        List supportedLanguages = this.config.getStringList("language.supported");
        return supportedLanguages.contains(locale) ? locale : this.config.getString("language.default", "pt-BR");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processPurchase(Player player, int price) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT saldo FROM banco WHERE jogador = ?");){
            stmt.setString(1, player.getName());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return false;
                int saldo = rs.getInt("saldo");
                if (saldo >= price) {
                    try (PreparedStatement updateStmt2 = this.connection.prepareStatement("UPDATE banco SET saldo = saldo - ? WHERE jogador = ?");){
                        updateStmt2.setInt(1, price);
                        updateStmt2.setString(2, player.getName());
                        updateStmt2.executeUpdate();
                    }
                    boolean updateStmt2 = true;
                    return updateStmt2;
                }
                int falta = price - saldo;
                String lang = this.getPlayerLanguage(player);
                player.sendMessage(lang.equals("pt-BR") ? Component.text((String)"\ud83d\udcb0 Saldo insuficiente para realizar a compra. Falta: ", (TextColor)NamedTextColor.RED).append((Component)Component.text((int)falta, (TextColor)NamedTextColor.YELLOW)) : Component.text((String)"\ud83d\udcb0 Insufficient balance to make the purchase. Missing: ", (TextColor)NamedTextColor.RED).append((Component)Component.text((int)falta, (TextColor)NamedTextColor.YELLOW)));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            player.sendMessage((Component)Component.text((String)"\u26a0 Erro ao acessar o banco de dados.", (TextColor)NamedTextColor.RED));
            e.printStackTrace();
            return false;
        }
    }

    public void buyEnchantedApple(Player player) {
        int price = this.config.getInt("store.price.apple");
        String lang = this.getPlayerLanguage(player);
        player.sendMessage("\ud83c\udf73. Lang= " + lang);
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENCHANTED_GOLDEN_APPLE, 1)});
            Store.ajustarSaldo(player, "take", price);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83c\udf4e Voc\u00ea comprou uma Ma\u00e7\u00e3 Encantada por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83c\udf4e \u00a1Has comprado una Manzana Encantada por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83c\udf4e You bought an Enchanted Apple for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyEmerald(Player player) {
        int price = this.config.getInt("store.price.emerald");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.EMERALD, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou uma Esmeralda por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado una Esmeralda por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought an Emerald for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyGoldBlock(Player player) {
        int price = this.config.getInt("store.price.buyGoldBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLD_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83c\udfc6 Voc\u00ea comprou um Bloco de Ouro por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83c\udfc6 \u00a1Has comprado un Bloque de Oro por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83c\udfc6 You bought a Gold Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyDiamondBlock(Player player) {
        int price = this.config.getInt("store.price.buyDiamondBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Diamante por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Diamante por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Diamond Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyEmeraldBlock(Player player) {
        int price = this.config.getInt("store.price.buyEmeraldBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.EMERALD_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Esmeralda por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Esmeralda por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought an Emerald Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyNetheriteBlock(Player player) {
        int price = this.config.getInt("store.price.buyNetheriteBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ANCIENT_DEBRIS, 10)});
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Netherite por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Netherite por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Netherite Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyIronBlock(Player player) {
        int price = this.config.getInt("store.price.buyIronBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83c\udfc6 Voc\u00ea comprou um Bloco de Ferro por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83c\udfc6 \u00a1Has comprado un Bloque de Hierro por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83c\udfc6 You bought an Iron Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyLapisBlock(Player player) {
        int price = this.config.getInt("store.price.lapis");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.LAPIS_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de L\u00e1pis por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de L\u00e1piz por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Lapis Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyRedstoneBlock(Player player) {
        int price = this.config.getInt("store.price.redstone");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.REDSTONE_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Redstone por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Redstone por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Redstone Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyQuartzBlock(Player player) {
        int price = this.config.getInt("store.price.quartz");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.QUARTZ_BLOCK, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Quartzo por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Quartzo por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Quartz Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyClayBlock(Player player) {
        int price = this.config.getInt("store.price.clay");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CLAY, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Argila por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Argila por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Clay Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buySandBlock(Player player) {
        int price = this.config.getInt("store.price.buySandBlock");
        if (this.processPurchase(player, price)) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SAND, 1)});
            Store.ajustarSaldo(player, "take", price);
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udc8e Voc\u00ea comprou um Bloco de Areia por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udc8e \u00a1Has comprado un Bloque de Areia por $" + price + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udc8e You bought a Sand Block for $" + price + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyAllTools(Player player) {
        int totalPrice = this.config.getInt("store.price.buyAllTools");
        if (this.processPurchase(player, totalPrice)) {
            List<Material> tools = List.of(Material.DIAMOND_PICKAXE, Material.DIAMOND_AXE, Material.DIAMOND_SHOVEL, Material.DIAMOND_HOE, Material.DIAMOND_SWORD);
            Store.ajustarSaldo(player, "take", totalPrice);
            for (Material tool : tools) {
                ItemStack toolItem = new ItemStack(tool, 1);
                player.getInventory().addItem(new ItemStack[]{toolItem});
            }
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83d\udee0\ufe0f Voc\u00ea comprou todas as ferramentas por $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83d\udee0\ufe0f \u00a1Has comprado todas las herramientas por $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83d\udee0\ufe0f You bought all tools for $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buyAllFood(Player player) {
        int totalPrice = this.config.getInt("store.price.buyAllFood");
        if (this.processPurchase(player, totalPrice)) {
            List<Material> foodItems = List.of(Material.APPLE, Material.BREAD, Material.COOKED_BEEF, Material.COOKED_CHICKEN, Material.COOKED_MUTTON, Material.COOKED_PORKCHOP, Material.COOKED_RABBIT, Material.CARROT, Material.POTATO, Material.BAKED_POTATO, Material.GOLDEN_CARROT, Material.BEETROOT, Material.BEETROOT_SOUP, Material.MUSHROOM_STEW, Material.MELON_SLICE, Material.PUMPKIN_PIE, Material.COOKIE);
            Store.ajustarSaldo(player, "take", totalPrice);
            for (Material food : foodItems) {
                ItemStack foodItem = new ItemStack(food, 5);
                player.getInventory().addItem(new ItemStack[]{foodItem});
            }
            String lang = this.getPlayerLanguage(player);
            player.sendMessage((Component)(lang.equals("pt-BR") ? Component.text((String)("\ud83c\udf7d\ufe0f Voc\u00ea comprou todos os alimentos por $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD) : (lang.equals("es-ES") ? Component.text((String)("\ud83c\udf7d\ufe0f \u00a1Has comprado todos los alimentos por $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD) : Component.text((String)("\ud83c\udf7d\ufe0f You bought all food items for $" + totalPrice + "!"), (TextColor)NamedTextColor.GOLD))));
        }
    }

    public void buySimpleBook(Player player) {
        int price = this.config.getInt("store.price.buySimpleBook", 50);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        String command = String.format("give %s minecraft:book 1", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        String lang = this.getPlayerLanguage(player);
        player.sendMessage(Component.text((String)"\ud83d\udcd6 ").append((Component)(lang.equals("pt-BR") ? Component.text((String)("Voc\u00ea comprou um livro simples por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : (lang.equals("es-ES") ? Component.text((String)("\u00a1Has comprado un libro simple por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : Component.text((String)("You bought a simple book for $" + price + "!"), (TextColor)NamedTextColor.GRAY)))));
    }

    public void buySimpleMap(Player player) {
        int price = this.config.getInt("store.price.buySimpleMap", 100);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        List<String> commands = Arrays.asList("minecraft:enchant " + player.getName() + " mending 1", "minecraft:enchant " + player.getName() + " efficiency 5", "minecraft:enchant " + player.getName() + " fortune 3", "minecraft:enchant " + player.getName() + " unbreaking 3", "minecraft:enchant " + player.getName() + " featherfall 4", "minecraft:enchant " + player.getName() + " frostwalker 2", "minecraft:enchant " + player.getName() + " projectileprotection 4", "minecraft:enchant " + player.getName() + " soulspeed 3", "minecraft:enchant " + player.getName() + " swiftsneak 3", "minecraft:enchant " + player.getName() + " respiration 3", "minecraft:enchant " + player.getName() + " thorns 3", "minecraft:give " + player.getName() + " filled_map 1");
        for (String command : commands) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        String lang = this.getPlayerLanguage(player);
        player.sendMessage(Component.text((String)"\ud83d\uddfa\ufe0f ").append((Component)(lang.equals("pt-BR") ? Component.text((String)("Voc\u00ea comprou um mapa simples por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : (lang.equals("es-ES") ? Component.text((String)("\u00a1Has comprado un mapa simple por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : Component.text((String)("You bought a simple map for $" + price + "!"), (TextColor)NamedTextColor.GRAY)))));
    }

    public void buySimpleCompass(Player player) {
        int price = this.config.getInt("store.price.buySimpleCompass", 150);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        List<String> commands = Arrays.asList("minecraft:enchant " + player.getName() + " looting 3", "minecraft:enchant " + player.getName() + " mending 1", "minecraft:enchant " + player.getName() + " smite 5", "minecraft:enchant " + player.getName() + " knockback 2", "minecraft:enchant " + player.getName() + " fire_aspect 2", "minecraft:enchant " + player.getName() + " unbreaking 3", "minecraft:give " + player.getName() + " recovery_compass 1");
        for (String command : commands) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        String lang = this.getPlayerLanguage(player);
        String message = lang.equals("pt-BR") ? "\ud83e\udded Voc\u00ea comprou uma b\u00fassola simples por $" + price + "!" : (lang.equals("es-ES") ? "\ud83e\udded \u00a1Has comprado una br\u00fajula simple por $" + price + "!" : "\ud83e\udded You bought a simple compass for $" + price + "!");
        player.sendMessage(Component.text((String)message).color((TextColor)NamedTextColor.GRAY));
    }

    public void buySimpleFishingRod(Player player) {
        int price = this.config.getInt("store.price.buySimpleFishingRod", 200);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        String command = String.format("give %s minecraft:fishing_rod 1", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        String lang = this.getPlayerLanguage(player);
        player.sendMessage(Component.text((String)"\ud83c\udfa3 ").append((Component)(lang.equals("pt-BR") ? Component.text((String)("Voc\u00ea comprou uma Vara de Pesca com Isca por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : (lang.equals("es-ES") ? Component.text((String)("\u00a1Has comprado una Ca\u00f1a de Pescar con Cebo por $" + price + "!"), (TextColor)NamedTextColor.GRAY) : Component.text((String)("You bought a Fishing Rod with Bait for $" + price + "!"), (TextColor)NamedTextColor.GRAY)))));
    }

    public void buySpinningWand(Player player) {
        int price = this.config.getInt("store.price.buySpinningWand", 800);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        String command = String.format("give %s minecraft:debug_stick 1", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        String lang = this.getPlayerLanguage(player);
        player.sendMessage(Component.text((String)"\u2728 ").append((Component)(lang.equals("pt-BR") ? Component.text((String)("Voc\u00ea comprou um Debug Stick por $" + price + "!"), (TextColor)NamedTextColor.LIGHT_PURPLE) : (lang.equals("es-ES") ? Component.text((String)("\u00a1Has comprado un Debug Stick por $" + price + "!"), (TextColor)NamedTextColor.LIGHT_PURPLE) : Component.text((String)("You bought a Debug Stick for $" + price + "!"), (TextColor)NamedTextColor.LIGHT_PURPLE)))));
    }

    public void buyAxolotlBucket(Player player) {
        int price = this.config.getInt("store.price.axolotl_bucket", 500);
        if (!this.processPurchase(player, price)) {
            return;
        }
        Store.ajustarSaldo(player, "take", price);
        String command = String.format("give %s minecraft:axolotl_bucket 1", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        String lang = this.getPlayerLanguage(player);
        player.sendMessage(Component.text((String)"\ud83e\udea3 ").append((Component)(lang.equals("pt-BR") ? Component.text((String)("Voc\u00ea comprou um balde com Axolote por $" + price + "!"), (TextColor)NamedTextColor.AQUA) : (lang.equals("es-ES") ? Component.text((String)("\u00a1Has comprado un cubo con Axolote por $" + price + "!"), (TextColor)NamedTextColor.AQUA) : Component.text((String)("You bought an Axolotl Bucket for $" + price + "!"), (TextColor)NamedTextColor.AQUA)))));
    }

    public static boolean setupEconomy() {
        RegisteredServiceProvider serviceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (serviceProvider != null) {
            economy = (Economy)serviceProvider.getProvider();
        }
        return economy != null;
    }

    public static void ajustarSaldo(Player player, String tipo, double valor) {
        if (economy == null && !Store.setupEconomy()) {
            player.sendMessage("Sistema de economia n\u00e3o est\u00e1 configurado!");
            return;
        }
        switch (tipo.toLowerCase()) {
            case "give": {
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "take": {
                economy.withdrawPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "set": {
                double saldoAtual = economy.getBalance((OfflinePlayer)player);
                economy.withdrawPlayer((OfflinePlayer)player, saldoAtual);
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
            default: {
                player.sendMessage("Comando inv\u00e1lido! Use 'give', 'take' ou 'set'.");
            }
        }
    }

    public void transferirtokengamer(Player player, String recipient, double amount) {
        try (PreparedStatement stmtJogador = this.connection.prepareStatement("UPDATE banco SET saldo = saldo - ? WHERE jogador = ?");
             PreparedStatement stmtDestinatario = this.connection.prepareStatement("UPDATE banco SET saldo = saldo + ? WHERE jogador = ?");){
            stmtJogador.setDouble(1, amount);
            stmtJogador.setString(2, player.getName());
            stmtJogador.executeUpdate();
            stmtDestinatario.setDouble(1, amount);
            stmtDestinatario.setString(2, recipient);
            stmtDestinatario.executeUpdate();
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco give " + recipient + " " + amount));
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco take " + player.getName() + " " + amount));
        }
        catch (SQLException e) {
            System.out.println("\u26a0 Erro ao atualizar o banco de dados: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

