/*
 * Decompiled with CFR 0.152.
 */
package com.SolanaDevMinecraft;

import com.SolanaDevMinecraft.WalletInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Solana {
    private final Connection connection;
    private final FileConfiguration config;
    private static Economy economy;
    private static final Logger LOGGER;

    public Solana(FileConfiguration config, Connection connection) {
        this.config = config;
        this.connection = connection;
    }

    public String getPlayerLanguage(Player player) {
        String locale = player.getLocale();
        List supportedLanguages = this.config.getStringList("language.supported");
        return supportedLanguages.contains(locale) ? locale : this.config.getString("language.default", "pt-BR");
    }

    public double getSolanaBalance(String walletAddress) throws Exception {
        String host = this.config.getString("docker.host");
        String apiwebkey = this.config.getString("docker.api_web_key");
        String comando = "solana balance " + walletAddress;
        String url = String.format("http://%s/consulta.php?apikey=%s&comando=%s", host, apiwebkey, URLEncoder.encode(comando, "UTF-8"));
        String response = this.executeHttpGet(url);
        if (response.contains("\"status\":\"success\"")) {
            String output = response.split("\"output\":\"")[1].split("\"")[0].replace(" SOL", "").trim();
            return Double.parseDouble(output);
        }
        throw new Exception("Erro ao obter saldo: " + response);
    }

    private String executeHttpGet(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }

    public void transferSolana(Player sender, String recipient, double amount) {
        double senderBalance;
        String senderWallet = this.getWalletFromDatabase(sender.getName());
        String recipientWallet = this.getWalletFromDatabase(recipient);
        if (senderWallet == null) {
            sender.sendMessage(Component.text((String)"\u274c Voc\u00ea n\u00e3o possui uma carteira registrada.").color(TextColor.color((int)0xFF0000)));
            return;
        }
        if (recipientWallet == null) {
            sender.sendMessage(Component.text((String)("\u274c O jogador " + recipient + " n\u00e3o possui uma carteira registrada.")).color(TextColor.color((int)0xFF0000)));
            return;
        }
        try {
            senderBalance = this.getSolanaBalance(senderWallet);
        }
        catch (Exception e) {
            sender.sendMessage(Component.text((String)("\u26a0 Erro ao obter saldo da carteira: " + e.getMessage())).color(TextColor.color((int)0xFF0000)));
            e.printStackTrace();
            return;
        }
        if (senderBalance < amount) {
            sender.sendMessage(Component.text((String)("\u274c Saldo insuficiente para transfer\u00eancia. Saldo atual: " + senderBalance)).color(TextColor.color((int)0xFF0000)));
            return;
        }
        try {
            String signature;
            String host = this.config.getString("docker.host");
            String apiwebkey = this.config.getString("docker.api_web_key");
            DecimalFormat df = new DecimalFormat("0.##");
            String formattedAmount = String.format("%.2f", amount).replace(",", ".");
            String comando = String.format("solana transfer %s %s --keypair /solana-token/wallets/%s_wallet.json --allow-unfunded-recipient", recipientWallet, formattedAmount, sender.getName().replace(" ", "_").toLowerCase());
            String url = String.format("http://%s/consulta.php?apikey=%s&comando=%s", host, apiwebkey, URLEncoder.encode(comando, StandardCharsets.UTF_8));
            String response = this.executeHttpGet(url);
            if (response != null && response.contains("\"output\":\"")) {
                signature = response.split("\"output\":\"")[1].split("\"")[0].trim();
                signature = response.replaceFirst("(?s).*Signature: ", "").replaceAll("\n", "").replaceAll("\"}", "").trim();
                try (PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO livro_caixa (jogador, tipo_transacao, valor, moeda, assinatura) VALUES (?, ?, ?, ?, ?)");){
                    stmt.setString(1, sender.getName());
                    stmt.setString(2, "transfer\u00eancia");
                    stmt.setDouble(3, amount);
                    stmt.setString(4, "SOL");
                    stmt.setString(5, signature);
                    stmt.executeUpdate();
                }
            } else {
                throw new Exception("\u274c Erro ao transferir SOL: " + response);
            }
            this.sendTransactionMessage(sender, recipient, amount, signature);
        }
        catch (Exception e) {
            sender.sendMessage(Component.text((String)("\u26a0 Erro ao processar a transfer\u00eancia: " + e.getMessage())).color(TextColor.color((int)0xFF0000)));
            e.printStackTrace();
        }
    }

    private void sendTransactionMessage(Player sender, String recipient, double amount, String signature) {
        sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\ud83d\udcb8 Transfer\u00eancia conclu\u00edda! ").color(TextColor.color((int)65280))).append(Component.text((String)(amount + " SOL para ")).color(TextColor.color((int)16766720)))).append(Component.text((String)recipient).color(TextColor.color((int)65535)))).append(Component.text((String)". Assinatura: ").color(TextColor.color((int)65280)))).append(Component.text((String)signature).color(TextColor.color((int)0xFFFF00))));
    }

    public void registerTransaction(String player, String transactionType, double amount, String currency, String signature) {
        try {
            PreparedStatement statement = this.connection.prepareStatement("INSERT INTO livro_caixa (jogador, tipo_transacao, valor, moeda, assinatura) VALUES (?, ?, ?, ?, ?)");
            statement.setString(1, player);
            statement.setString(2, transactionType);
            statement.setDouble(3, amount);
            statement.setString(4, currency);
            statement.setString(5, signature);
            statement.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String executeCommand(String command) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        builder.redirectErrorStream(true);
        Process process = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            String string = output.toString().trim();
            return string;
        }
    }

    private String extractSignature(String output) {
        String[] lines;
        for (String line : lines = output.split(" ")) {
            if (!line.startsWith("Minecraft-Sigmaboy: ")) continue;
            return line.substring(10).trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWalletFromDatabase(String username) {
        String walletAddress = null;
        Connection manualConnection = null;
        try {
            LOGGER.info("Conectando ao banco de dados para buscar a carteira do usu\u00e1rio: " + username);
            String url = this.config.getString("database.url");
            String user = this.config.getString("database.user");
            String password = this.config.getString("database.password");
            manualConnection = DriverManager.getConnection(url, user, password);
            String query = "SELECT c.endereco FROM carteiras c JOIN jogadores j ON c.jogador_id = j.id WHERE LOWER(j.nome) = LOWER(?)";
            PreparedStatement stmt = manualConnection.prepareStatement(query);
            stmt.setString(1, username.trim());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                walletAddress = rs.getString("endereco");
                LOGGER.info("Carteira encontrada para o usu\u00e1rio " + username + ": " + walletAddress);
            } else {
                LOGGER.warning("Nenhuma carteira encontrada para o usu\u00e1rio: " + username);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Erro ao buscar carteira no banco: " + e.getMessage());
        }
        finally {
            try {
                if (manualConnection != null) {
                    manualConnection.close();
                }
            }
            catch (Exception e) {
                LOGGER.severe("Erro ao fechar conex\u00e3o: " + e.getMessage());
            }
        }
        return walletAddress;
    }

    public void logWalletAddress(Player player) {
        String username = player.getName();
        String walletAddress = this.getWalletFromDatabase(username);
        if (walletAddress != null) {
            System.out.println("Endere\u00e7o da carteira para " + username + ": " + walletAddress);
        } else {
            System.out.println("Nenhuma carteira encontrada para o jogador: " + username);
        }
    }

    public void handleSolBalance(Player player) {
        if (player == null) {
            LOGGER.severe("O objeto Player \u00e9 nulo.");
            return;
        }
        String playerName = player.getName();
        if (playerName == null || playerName.isEmpty()) {
            LOGGER.severe("O nome do jogador \u00e9 nulo ou vazio.");
            player.sendMessage("Erro: N\u00e3o foi poss\u00edvel identificar o jogador.");
            return;
        }
        player.sendMessage(((TextComponent)Component.text((String)"\ud83d\udd0d Obtendo o saldo de SOL para o jogador: ").color(TextColor.color((int)0x800080))).append(Component.text((String)player.getName()).color(TextColor.color((int)16766720))));
        String walletAddress = this.getWalletFromDatabase(player.getName());
        if (walletAddress == null) {
            LOGGER.warning("Nenhuma carteira encontrada para o jogador: " + player.getName());
            String lang = this.getPlayerLanguage(player);
            if (lang.equals("pt-BR")) {
                player.sendMessage(Component.text((String)"\ud83d\udcb3 Voc\u00ea ainda n\u00e3o possui uma carteira registrada.").color(TextColor.color((int)0xFF0000)));
            } else if (lang.equals("es-ES")) {
                player.sendMessage(Component.text((String)"\ud83d\udcb3 A\u00fan no tienes una billetera registrada.").color(TextColor.color((int)0xFF0000)));
            } else {
                player.sendMessage(Component.text((String)"\ud83d\udcb3 You do not have a registered wallet yet.").color(TextColor.color((int)0xFF0000)));
            }
            return;
        }
        player.sendMessage(((TextComponent)Component.text((String)"\ud83d\udcb3 Carteira SOL: ").color(TextColor.color((int)16766720))).append(((TextComponent)Component.text((String)walletAddress).color(TextColor.color((int)65535))).clickEvent(ClickEvent.suggestCommand((String)walletAddress))));
        LOGGER.info("Endere\u00e7o da carteira encontrado: " + walletAddress);
        try {
            double balance = this.getSolanaBalance(walletAddress);
            LOGGER.info("Saldo obtido para a carteira " + walletAddress + ": " + balance + " SOL");
            String lang = this.getPlayerLanguage(player);
            if (lang.equals("pt-BR")) {
                player.sendMessage(Component.text((String)"\ud83d\udcb0 Seu saldo de SOL \u00e9: ").color(TextColor.color((int)0x800080)));
            } else if (lang.equals("es-ES")) {
                player.sendMessage(Component.text((String)"\ud83d\udcb0 Tu saldo de SOL es: ").color(TextColor.color((int)0x800080)));
            } else {
                player.sendMessage(Component.text((String)"\ud83d\udcb0 Your SOL balance is: ").color(TextColor.color((int)0x800080)));
            }
            player.sendMessage(Component.text((String)(" " + balance + " SOL")).color(TextColor.color((int)16766720)));
        }
        catch (Exception e) {
            LOGGER.severe("Erro ao verificar saldo para a carteira " + walletAddress + ": " + e.getMessage());
            player.sendMessage("Erro ao verificar saldo: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void buyGameCurrency(Player player, double solAmount) {
        block25: {
            int conversionRate = this.config.getInt("store.value_of_in_game_currency", 1000);
            int gameCurrencyAmount = (int)(solAmount * (double)conversionRate);
            String lang = this.getPlayerLanguage(player);
            String playerWallet = this.getWalletFromDatabase(player.getName());
            if (playerWallet == null) {
                if (lang.equals("pt-BR")) {
                    player.sendMessage("\u274c Voc\u00ea ainda n\u00e3o possui uma carteira registrada.");
                    player.sendMessage(Component.text((String)"\ud83d\udcb3 Crie uma carteira usando /createwallet.").color(TextColor.color((int)0xFF0000)));
                } else if (lang.equals("es-ES")) {
                    player.sendMessage("\u274c A\u00fan no tienes una billetera registrada.");
                    player.sendMessage(Component.text((String)"\ud83d\udcb3 Crea una billetera usando /createwallet.").color(TextColor.color((int)0xFF0000)));
                } else {
                    player.sendMessage("\u274c You do not yet have a registered wallet.");
                    player.sendMessage(Component.text((String)"\ud83d\udcb3 Create a wallet using /createwallet.").color(TextColor.color((int)0xFF0000)));
                }
                return;
            }
            try {
                double solBalance = this.getSolanaBalance(playerWallet);
                if (solBalance < solAmount) {
                    if (lang.equals("pt-BR")) {
                        player.sendMessage("\ud83d\udcb0 Saldo insuficiente de SOL. Saldo atual: " + solBalance);
                    } else if (lang.equals("es-ES")) {
                        player.sendMessage("\ud83d\udcb0 Saldo insuficiente de SOL. Saldo actual: " + solBalance);
                    } else {
                        player.sendMessage("\ud83d\udcb0 Insufficient SOL balance. Current balance: " + solBalance);
                    }
                    return;
                }
                String host = this.config.getString("docker.host");
                String apiwebkey = this.config.getString("docker.api_web_key");
                String bank = this.config.getString("docker.wallet_bank_store_admin");
                DecimalFormat df = new DecimalFormat("0.##");
                String formattedAmount = String.format("%.2f", solAmount).replace(",", ".");
                String comando = String.format("solana transfer %s %s --keypair /solana-token/wallets/%s_wallet.json --allow-unfunded-recipient", bank, formattedAmount, player.getName().replace(" ", "_").toLowerCase());
                String url = String.format("http://%s/consulta.php?apikey=%s&comando=%s", host, apiwebkey, URLEncoder.encode(comando, "UTF-8"));
                String response = this.executeHttpGet(url);
                LOGGER.info("[DEBUG SOLANA BUY RESPONSE]: " + response);
                if (response.contains("\"status\":\"success\"")) {
                    String signature = response.split("\"output\":\"")[1].split("\"")[0].trim();
                    signature = response.replaceFirst("(?s).*Signature: ", "").trim();
                    signature = signature.replaceAll("\\n", "");
                    signature = signature.replaceAll("\"}", "");
                    signature = signature.trim();
                    try (PreparedStatement updateStatement = this.connection.prepareStatement("UPDATE banco SET saldo = saldo + ? WHERE jogador = ?");){
                        updateStatement.setInt(1, gameCurrencyAmount);
                        updateStatement.setString(2, player.getName());
                        int rowsUpdated = updateStatement.executeUpdate();
                        if (rowsUpdated > 0) {
                            this.registerTransaction(player.getName(), "compra", solAmount, "SOL", signature);
                            Solana.ajustarSaldo(player, "give", gameCurrencyAmount);
                            if (lang.equals("pt-BR")) {
                                player.sendMessage(((TextComponent)Component.text((String)"\u2705 Compra realizada com sucesso! ").color(TextColor.color((int)65280))).append(Component.text((String)("Voc\u00ea recebeu " + gameCurrencyAmount + " moedas.")).color(TextColor.color((int)16766720))));
                                player.sendMessage(((TextComponent)Component.text((String)"\ud83d\udcb8 Transa\u00e7\u00e3o registrada com assinatura: ").color(TextColor.color((int)65535))).append(Component.text((String)signature).color(TextColor.color((int)0xFFFF00))));
                            } else if (lang.equals("es-ES")) {
                                player.sendMessage(((TextComponent)Component.text((String)"\u2705 Compra realizada con \u00e9xito! ").color(TextColor.color((int)65280))).append(Component.text((String)("Recibiste " + gameCurrencyAmount + " monedas.")).color(TextColor.color((int)16766720))));
                                player.sendMessage(((TextComponent)Component.text((String)"\ud83d\udcb8 Transacci\u00f3n registrada con firma: ").color(TextColor.color((int)65535))).append(Component.text((String)signature).color(TextColor.color((int)0xFFFF00))));
                            } else {
                                player.sendMessage(((TextComponent)Component.text((String)"\u2705 Purchase completed successfully! ").color(TextColor.color((int)65280))).append(Component.text((String)("You received " + gameCurrencyAmount + " coins.")).color(TextColor.color((int)16766720))));
                                player.sendMessage(((TextComponent)Component.text((String)"\ud83d\udcb8 Transaction registered with signature: ").color(TextColor.color((int)65535))).append(Component.text((String)signature).color(TextColor.color((int)0xFFFF00))));
                            }
                        } else {
                            player.sendMessage("\u26a0 Erro ao atualizar seu saldo no banco.");
                        }
                        break block25;
                    }
                }
                throw new Exception("\u274c Erro ao transferir SOL: " + response);
            }
            catch (Exception e) {
                player.sendMessage("\u26a0 Erro ao processar a compra: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWallet(Player player) {
        String username = player.getName();
        boolean exists = false;
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String url = this.config.getString("database.url");
            String user = this.config.getString("database.user");
            String password = this.config.getString("database.password");
            connection = DriverManager.getConnection(url, user, password);
            String query = "SELECT endereco FROM carteiras WHERE jogador_id = (SELECT id FROM jogadores WHERE nome = ?)";
            stmt = connection.prepareStatement(query);
            stmt.setString(1, username.trim());
            rs = stmt.executeQuery();
            exists = rs.next();
        }
        catch (Exception e) {
            LOGGER.severe("Erro ao verificar carteira no banco: " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                LOGGER.severe("Erro ao fechar conex\u00e3o: " + e.getMessage());
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createWallet(Player player) {
        String playerName = player.getName().replace(" ", "_").toLowerCase();
        String walletPath = String.format("wallets/%s_wallet.json", playerName);
        Statement statement = null;
        String lang = this.getPlayerLanguage(player);
        boolean hasWallet = this.hasWallet(player);
        if (hasWallet) {
            if (lang.equals("pt-BR")) {
                player.sendMessage(Component.text((String)"\u274c Voc\u00ea j\u00e1 possui uma carteira registrada.").color(TextColor.color((int)0xFF0000)));
                return;
            } else if (lang.equals("es-ES")) {
                player.sendMessage(Component.text((String)"\u274c Ya tienes una billetera registrada.").color(TextColor.color((int)0xFF0000)));
                return;
            } else {
                player.sendMessage(Component.text((String)"\u274c You already have a registered wallet.").color(TextColor.color((int)0xFF0000)));
            }
            return;
        }
        try {
            int jogadorId;
            String host = this.config.getString("docker.host");
            String apiwebkey = this.config.getString("docker.api_web_key");
            String comandoGerar = String.format("solana-keygen new --no-passphrase --outfile %s --force", walletPath);
            String urlGerar = String.format("http://%s/consulta.php?apikey=%s&comando=%s", host, apiwebkey, URLEncoder.encode(comandoGerar, "UTF-8"));
            String responseGerar = this.executeHttpGet(urlGerar);
            if (!responseGerar.contains("\"status\":\"success\"")) {
                throw new Exception("\u274c Erro ao criar carteira: " + responseGerar);
            }
            String walletData = new String(responseGerar);
            WalletInfo walletInfo = this.extractWalletInfo(walletData);
            String walletAddress = walletInfo.walletAddress;
            String secretPhrase = walletInfo.secretPhrase;
            String comandoLer = String.format("cat %s", walletPath);
            String urlLer = String.format("http://%s/consulta.php?apikey=%s&comando=%s", host, apiwebkey, URLEncoder.encode(comandoLer, "UTF-8"));
            String responseLer = this.executeHttpGet(urlLer);
            if (!responseLer.contains("\"status\":\"success\"")) {
                throw new Exception("\u274c Erro ao ler carteira: " + responseLer);
            }
            String privateKeyHex = Solana.convertPrivateKeyToHex(responseLer);
            PreparedStatement checkPlayer = this.connection.prepareStatement("SELECT id FROM jogadores WHERE nome = ?");
            checkPlayer.setString(1, playerName);
            ResultSet rs = checkPlayer.executeQuery();
            if (!rs.next()) {
                PreparedStatement createPlayer = this.connection.prepareStatement("INSERT INTO jogadores (nome) VALUES (?)", 1);
                createPlayer.setString(1, playerName);
                createPlayer.executeUpdate();
                ResultSet generatedKeys = createPlayer.getGeneratedKeys();
                if (!generatedKeys.next()) throw new Exception("\u274c Erro ao registrar novo jogador!");
                jogadorId = generatedKeys.getInt(1);
            } else {
                jogadorId = rs.getInt("id");
            }
            statement = this.connection.prepareStatement("INSERT INTO carteiras (jogador_id, endereco, chave_privada, frase_secreta) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE endereco = ?, chave_privada = ?, frase_secreta = ?");
            statement.setInt(1, jogadorId);
            statement.setString(2, walletAddress);
            statement.setString(3, privateKeyHex);
            statement.setString(4, secretPhrase);
            statement.setString(5, walletAddress);
            statement.setString(6, privateKeyHex);
            statement.setString(7, secretPhrase);
            statement.executeUpdate();
            if (lang.equals("pt-BR")) {
                player.sendMessage(Component.text((String)("\u2705 Carteira criada com sucesso! Endere\u00e7o: " + walletAddress)).color(TextColor.color((int)65280)));
                player.sendMessage(Component.text((String)"\ud83d\udee1\ufe0f Guarde sua frase secreta com seguran\u00e7a!").color(TextColor.color((int)16766720)));
                player.sendMessage((Component)Component.text((String)("\u2705 SecretPhrase: " + (secretPhrase != null ? secretPhrase : "NULO"))));
                return;
            } else if (lang.equals("es-ES")) {
                player.sendMessage(Component.text((String)("\u2705 Billetera creada con \u00e9xito! Direcci\u00f3n: " + walletAddress)).color(TextColor.color((int)65280)));
                player.sendMessage(Component.text((String)"\ud83d\udee1\ufe0f \u00a1Guarda tu frase secreta a salvo!").color(TextColor.color((int)16766720)));
                player.sendMessage((Component)Component.text((String)("\u2705 Frase secreta: " + (secretPhrase != null ? secretPhrase : "NULO"))));
                return;
            } else {
                player.sendMessage(Component.text((String)("\u2705 Wallet created successfully! Address: " + walletAddress)).color(TextColor.color((int)65280)));
                player.sendMessage(Component.text((String)"\ud83d\udee1\ufe0f Keep your secret phrase safe!").color(TextColor.color((int)16766720)));
                player.sendMessage((Component)Component.text((String)("\u2705 SecretPhrase: " + (secretPhrase != null ? secretPhrase : "NULO"))));
            }
            return;
        }
        catch (Exception e) {
            player.sendMessage(Component.text((String)("\u26a0 Erro ao criar a carteira: " + e.getMessage())).color(TextColor.color((int)0xFF0000)));
            e.printStackTrace();
            return;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.warning("\u274c Erro ao fechar conex\u00e3o: " + e.getMessage());
                }
            }
        }
    }

    private WalletInfo extractWalletInfo(String walletData) {
        try {
            if (walletData.contains("pubkey: ")) {
                walletData = walletData.substring(walletData.indexOf("pubkey: "));
            }
            Pattern patternAddress = Pattern.compile("pubkey: ([A-Za-z0-9]+)");
            Matcher matcherAddress = patternAddress.matcher(walletData);
            Pattern patternPhrase = Pattern.compile("Save this seed phrase to recover your new keypair:\\s*([^\n\r=]+)");
            Matcher matcherPhrase = patternPhrase.matcher(walletData);
            String walletAddress = matcherAddress.find() ? matcherAddress.group(1).trim() : null;
            String secretPhrase = matcherPhrase.find() ? matcherPhrase.group(1).replaceAll("^[\\n\\r]+|[\\n\\r]+$", "").trim() : null;
            LOGGER.info("[DEBUG] Endere\u00e7o da Carteira: " + walletAddress);
            LOGGER.info("[DEBUG] Frase Secreta: " + secretPhrase);
            return new WalletInfo(walletAddress, secretPhrase, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertPrivateKeyToHex(String jsonResponse) {
        try {
            Pattern pattern = Pattern.compile("\"output\":\"\\[(.*?)\\]\"");
            Matcher matcher = pattern.matcher(jsonResponse);
            if (!matcher.find()) {
                System.err.println("[ERRO] Campo 'output' n\u00e3o encontrado ou mal formatado!");
                return null;
            }
            String numbersOnly = matcher.group(1).trim();
            System.out.println("[DEBUG] N\u00fameros Extra\u00eddos: " + numbersOnly);
            String[] numberStrings = numbersOnly.split(",");
            byte[] secretKeyArray = new byte[numberStrings.length];
            for (int i = 0; i < numberStrings.length; ++i) {
                secretKeyArray[i] = (byte)Integer.parseInt(numberStrings[i].trim());
            }
            StringBuilder hexString = new StringBuilder();
            for (byte b : secretKeyArray) {
                hexString.append(String.format("%02x", b));
            }
            System.out.println("[DEBUG] Chave privada em HEX: " + hexString.toString());
            return hexString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean setupEconomy() {
        RegisteredServiceProvider serviceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (serviceProvider != null) {
            economy = (Economy)serviceProvider.getProvider();
        }
        return economy != null;
    }

    public static void ajustarSaldo(Player player, String tipo, double valor) {
        if (economy == null && !Solana.setupEconomy()) {
            player.sendMessage("Sistema de economia n\u00e3o est\u00e1 configurado!");
            return;
        }
        switch (tipo.toLowerCase()) {
            case "give": {
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "take": {
                economy.withdrawPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "set": {
                double saldoAtual = economy.getBalance((OfflinePlayer)player);
                economy.withdrawPlayer((OfflinePlayer)player, saldoAtual);
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
        }
    }

    public void transferirMoeda(Player player, String destinatario, double valor) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco give " + destinatario + " " + valor));
        player.sendMessage("Voc\u00ea transferiu " + valor + " moedas para " + destinatario);
    }

    public void transferirMoedaBanco(String jogador, String destinatario, double valor) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco give " + destinatario + " " + valor));
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco take " + jogador + " " + valor));
    }

    static {
        LOGGER = Logger.getLogger(Solana.class.getName());
    }
}

