/*
 * Decompiled with CFR 0.152.
 */
package com.SolanaDevMinecraft;

import com.SolanaDevMinecraft.Solana;
import com.SolanaDevMinecraft.Store;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class App
extends JavaPlugin
implements Listener {
    private Connection connection;
    private Solana solana;
    private Store store;
    private FileConfiguration config;
    private static Economy economy;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getLogger().info("Plugin habilitado!");
        this.connectToDatabase();
        this.solana = new Solana(this.config, this.connection);
        this.store = new Store(this.config, this.connection);
        this.createDatabaseAndTables();
        new BukkitRunnable(){

            public void run() {
                App.this.updateDebts();
            }
        }.runTaskTimer((Plugin)this, 0L, 1200L);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    App.this.processInvestments(player, player.locale().toString());
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 6000L);
    }

    public void onDisable() {
        this.getLogger().info("Plugin desabilitado!");
        this.disconnectFromDatabase();
    }

    @EventHandler
    public void aoEntrarNoServidor(PlayerJoinEvent event) {
        Player jogador = event.getPlayer();
        this.checkBalance(jogador);
    }

    private void connectToDatabase() {
        try {
            String url = this.config.getString("database.url");
            String user = this.config.getString("database.user");
            String password = this.config.getString("database.password");
            this.getLogger().info("Tentando conectar ao banco de dados com URL: " + url);
            this.connection = DriverManager.getConnection(url, user, password);
            this.getLogger().info("Conectado ao banco de dados!");
        }
        catch (Exception e) {
            this.getLogger().severe("Erro ao conectar ao banco de dados: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void disconnectFromDatabase() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.getLogger().info("Conex\u00e3o com o banco de dados encerrada.");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Erro ao encerrar conex\u00e3o com o banco de dados: " + e.getMessage());
        }
    }

    public String getPlayerLanguage(Player player) {
        String locale = player.getLocale();
        List supportedLanguages = this.config.getStringList("language.supported");
        return supportedLanguages.contains(locale) ? locale : this.config.getString("language.default", "pt-BR");
    }

    private void ensureConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.getLogger().warning("Conex\u00e3o com o banco de dados perdida, tentando reconectar...");
                this.connectToDatabase();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Erro ao verificar a conex\u00e3o com o banco de dados: " + e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.ensureConnection();
        if (command.getName().equalsIgnoreCase("saldo")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                String lang = this.store.getPlayerLanguage(player);
                this.checkBalance(player);
            } else {
                sender.sendMessage("Este comando s\u00f3 pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("loan")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    try {
                        double amount = Double.parseDouble(args[0]);
                        this.giveLoan(player, amount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Por favor, insira um valor v\u00e1lido.");
                    }
                } else {
                    player.sendMessage("Uso correto: /loan <quantidade>");
                }
            } else {
                sender.sendMessage("Este comando s\u00f3 pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("createWallet")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                String lang = this.store.getPlayerLanguage(player);
                if (lang.equals("pt-BR")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Aguarde! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Pode levar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando ao banco Solana...", (TextColor)NamedTextColor.AQUA)));
                } else if (lang.equals("es-ES")) {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a1 \u00a1Espere! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Puede tardar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando al banco Solana...", (TextColor)NamedTextColor.AQUA)));
                } else {
                    player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Please wait! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"This may take 5 seconds...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Connecting to Solana bank...", (TextColor)NamedTextColor.AQUA)));
                }
                this.solana.createWallet(player);
            } else {
                sender.sendMessage("Este comando so pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("paydebt")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    try {
                        double amount = Double.parseDouble(args[0]);
                        this.payDebt(player, amount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Por favor, insira um valor v\u00e1lido.");
                    }
                } else {
                    player.sendMessage("Uso correto: /paydebt <quantidade>");
                }
            } else {
                sender.sendMessage("Este comando s\u00f3 pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buycurrency")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    try {
                        String lang = this.store.getPlayerLanguage(player);
                        if (lang.equals("pt-BR")) {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Aguarde! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Pode levar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando ao banco Solana...", (TextColor)NamedTextColor.AQUA)));
                        } else if (lang.equals("es-ES")) {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 \u00a1Espere! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Puede tardar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando al banco Solana...", (TextColor)NamedTextColor.AQUA)));
                        } else {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Please wait! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"This may take 5 seconds...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Connecting to Solana bank...", (TextColor)NamedTextColor.AQUA)));
                        }
                        double solAmount = Double.parseDouble(args[0]);
                        this.solana.buyGameCurrency(player, solAmount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Uso correto: /buycurrency <quantidade_SOL>");
                    }
                } else {
                    player.sendMessage("Uso correto: /buycurrency <quantidade_SOL>");
                }
            } else {
                sender.sendMessage("Este comando s\u00f3 pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyapple")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyEnchantedApple(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyemerald")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyEmerald(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("soltransfer")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 2) {
                    String recipient = args[0];
                    try {
                        String lang = this.store.getPlayerLanguage(player);
                        if (lang.equals("pt-BR")) {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Aguarde! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Pode levar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando ao banco Solana...", (TextColor)NamedTextColor.AQUA)));
                        } else if (lang.equals("es-ES")) {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 \u00a1Espere! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"Puede tardar 5 segundos...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Conectando al banco Solana...", (TextColor)NamedTextColor.AQUA)));
                        } else {
                            player.sendMessage(((TextComponent)Component.text((String)"\u26a1 Please wait! ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"This may take 5 seconds...", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"\n\ud83c\udf10 Connecting to Solana bank...", (TextColor)NamedTextColor.AQUA)));
                        }
                        double amount = Double.parseDouble(args[1]);
                        this.solana.transferSolana(player, recipient, amount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Uso correto: /soltransfer <jogador> <quantidade_SOL>");
                    }
                } else {
                    player.sendMessage("Uso correto: /soltransfer <jogador> <quantidade_SOL>");
                }
            } else {
                sender.sendMessage("Este comando so pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("transferirtokengamer")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 2) {
                    String recipient = args[0];
                    try {
                        String lang = this.store.getPlayerLanguage(player);
                        double amount = Double.parseDouble(args[1]);
                        this.store.transferirtokengamer(player, recipient, amount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Uso correto: /transferirtokengamer <jogador> <quantidade_SOL>");
                    }
                } else {
                    player.sendMessage("Uso correto: /transferirtokengamer <jogador> <quantidade_SOL>");
                }
            } else {
                sender.sendMessage("Este comando so pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("solbalance")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.solana.handleSolBalance(player);
            } else {
                sender.sendMessage("Este comando so pode ser usado por jogadores.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySpinningWand")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySpinningWand(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyiron")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyIronBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyEmeraldBlock")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyEmeraldBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buygold")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyGoldBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buydiamond")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyDiamondBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyLapis")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyLapisBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyQuartz")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyQuartzBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyClay")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyClayBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySimpleMap")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySimpleMap(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySimpleCompass")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySimpleCompass(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySimpleFishingRod")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySimpleFishingRod(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyAxolotlBucket")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyAxolotlBucket(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyRedstone")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyRedstoneBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySandBlock")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySandBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyAllTools")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyAllTools(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buyAllFood")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyAllFood(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buySimpleBook")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buySimpleBook(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("buynetherite")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.store.buyNetheriteBlock(player);
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("invest")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    try {
                        double amount = Double.parseDouble(args[0]);
                        this.invest(player, amount);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Por favor, insira um valor valido.");
                    }
                } else {
                    player.sendMessage("Uso correto: /invest <quantidade>");
                }
            } else {
                sender.sendMessage("Este comando so pode ser usado por jogadores.");
            }
            return true;
        }
        return false;
    }

    private void giveLoan(Player player, double amount) {
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE banco SET divida = divida + ?, saldo = saldo + ? WHERE jogador = ?");
            statement.setDouble(1, amount * 1.1);
            statement.setDouble(2, amount);
            statement.setString(3, player.getName());
            int rowsUpdated = statement.executeUpdate();
            if (rowsUpdated > 0) {
                player.sendMessage("Emprestimo aprovado! com banco nova divida: $" + amount * 1.1);
            } else {
                player.sendMessage("Voce ainda nao esta registrado no banco.");
            }
        }
        catch (Exception e) {
            player.sendMessage("Erro ao processar emprestimo.");
            this.getLogger().severe("Erro ao processar emprestimo: " + e.getMessage());
        }
    }

    private void payDebt(Player player, double amount) {
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE banco SET divida = GREATEST(divida - ?, 0), saldo = saldo - ? WHERE jogador = ?");
            statement.setDouble(1, amount);
            statement.setDouble(2, amount);
            statement.setString(3, player.getName());
            int rowsUpdated = statement.executeUpdate();
            if (rowsUpdated > 0) {
                App.ajustarSaldo(player, "take", amount);
                player.sendMessage("Pagamento de $" + amount + " realizado com sucesso.");
            } else {
                player.sendMessage("Voc\u00ea ainda n\u00e3o est\u00e1 registrado no banco.");
            }
        }
        catch (Exception e) {
            player.sendMessage("Erro ao processar pagamento da d\u00edvida.");
            this.getLogger().severe("Erro ao processar pagamento da d\u00edvida: " + e.getMessage());
        }
    }

    private void invest(Player player, double amount) {
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE banco SET investimento = investimento + ?, saldo = saldo - ? WHERE jogador = ?");
            statement.setDouble(1, amount);
            statement.setDouble(2, amount);
            statement.setString(3, player.getName());
            int rowsUpdated = statement.executeUpdate();
            if (rowsUpdated > 0) {
                App.ajustarSaldo(player, "take", amount);
                player.sendMessage("Investimento de $" + amount + " realizado com sucesso.");
            } else {
                player.sendMessage("Voc\u00ea ainda n\u00e3o est\u00e1 registrado no banco.");
            }
        }
        catch (Exception e) {
            player.sendMessage("Erro ao processar investimento.");
            this.getLogger().severe("Erro ao processar investimento: " + e.getMessage());
        }
    }

    private void updateDebts() {
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE banco SET divida = divida * 1.02 WHERE divida > 0");
            int rowsUpdated = statement.executeUpdate();
            if (rowsUpdated > 0) {
                this.getLogger().info("Juros aplicados \u00e0s d\u00edvidas.");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Erro ao atualizar d\u00edvidas: " + e.getMessage());
        }
    }

    private void processInvestments(Player player, String lang) {
        try {
            PreparedStatement getSaldoStmt = this.connection.prepareStatement("SELECT saldo, investimento FROM banco WHERE investimento > 0");
            ResultSet resultSet = getSaldoStmt.executeQuery();
            if (resultSet.next()) {
                double saldoAtual = resultSet.getDouble("saldo");
                double investimento = resultSet.getDouble("investimento");
                double saldoAtualizado = saldoAtual + investimento * 1.25;
                App.ajustarSaldo(player, "set", saldoAtualizado);
                PreparedStatement updateStmt = this.connection.prepareStatement("UPDATE banco SET saldo = saldo + investimento * 1.25, investimento = 0 WHERE investimento > 0");
                int rowsUpdated = updateStmt.executeUpdate();
                if (rowsUpdated > 0) {
                    this.getLogger().info("Retorno de investimentos processado.");
                    Component message = ((TextComponent)Component.text((String)"\ud83d\udcb0 Retorno de investimentos processado! \nNovo saldo: $ ").color(TextColor.color((int)65535))).append(Component.text((String)String.format("%.2f", saldoAtualizado)).color(TextColor.color((int)0xFFFF00)));
                    player.sendMessage(message);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Erro ao processar investimentos: " + e.getMessage());
        }
    }

    private void checkBalance(Player player) {
        try {
            PreparedStatement checkStatement = this.connection.prepareStatement("SELECT saldo FROM banco WHERE jogador = ?");
            checkStatement.setString(1, player.getName());
            ResultSet resultSet = checkStatement.executeQuery();
            if (resultSet.next()) {
                double saldoBanco = resultSet.getDouble("saldo");
                PreparedStatement updateStatement = this.connection.prepareStatement("UPDATE banco SET saldo = ? WHERE jogador = ?");
                updateStatement.setDouble(1, saldoBanco);
                updateStatement.setString(2, player.getName());
                updateStatement.executeUpdate();
                App.ajustarSaldo(player, "set", saldoBanco);
                String lang = this.store.getPlayerLanguage(player);
                Component message = lang.equals("pt-BR") ? ((TextComponent)Component.text((String)"\ud83d\udcb0 Seu saldo banc\u00e1rio foi atualizado: \n").color(TextColor.color((int)0x800080))).append(Component.text((String)(" $" + saldoBanco)).color(TextColor.color((int)0xFFFF00))) : (lang.equals("es-ES") ? ((TextComponent)Component.text((String)"\ud83d\udcb0 Su saldo bancario ha sido actualizado: \n").color(TextColor.color((int)0x800080))).append(Component.text((String)(" $" + saldoBanco)).color(TextColor.color((int)0xFFFF00))) : ((TextComponent)Component.text((String)"\ud83d\udcb0 Your bank balance has been updated: \n").color(TextColor.color((int)0x800080))).append(Component.text((String)(" $" + saldoBanco)).color(TextColor.color((int)0xFFFF00))));
                player.sendMessage(message);
            } else {
                PreparedStatement insertStatement = this.connection.prepareStatement("INSERT INTO banco (jogador, saldo) VALUES (?, 500)");
                insertStatement.setString(1, player.getName());
                insertStatement.executeUpdate();
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("eco give " + player.getName() + " 500"));
                String lang = this.store.getPlayerLanguage(player);
                Component message = lang.equals("pt-BR") ? Component.text((String)"\u2705 Voc\u00ea foi cadastrado no banco! Seu saldo inicial \u00e9 de 500 moedas.").color(TextColor.color((int)65280)) : (lang.equals("es-ES") ? Component.text((String)"\u2705 \u00a1Te has registrado en el banco! Tu saldo inicial es de 500 monedas.").color(TextColor.color((int)65280)) : Component.text((String)"\u2705 You have been registered in the bank! Your initial balance is 500 coins.").color(TextColor.color((int)65280)));
                player.sendMessage(message);
            }
        }
        catch (SQLException e) {
            player.sendMessage(Component.text((String)"\u274c Erro ao acessar o banco de dados.").color(TextColor.color((int)0xFF0000)));
            this.getLogger().severe("Erro ao consultar saldo: " + e.getMessage());
        }
    }

    public static boolean setupEconomy() {
        RegisteredServiceProvider serviceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (serviceProvider != null) {
            economy = (Economy)serviceProvider.getProvider();
        }
        return economy != null;
    }

    public static void ajustarSaldo(Player player, String tipo, double valor) {
        if (economy == null && !App.setupEconomy()) {
            player.sendMessage("Sistema de economia n\u00e3o est\u00e1 configurado!");
            return;
        }
        switch (tipo.toLowerCase()) {
            case "give": {
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "take": {
                economy.withdrawPlayer((OfflinePlayer)player, valor);
                break;
            }
            case "set": {
                double saldoAtual = economy.getBalance((OfflinePlayer)player);
                economy.withdrawPlayer((OfflinePlayer)player, saldoAtual);
                economy.depositPlayer((OfflinePlayer)player, valor);
                break;
            }
            default: {
                player.sendMessage("Comando inv\u00e1lido! Use 'give', 'take' ou 'set'.");
            }
        }
    }

    private void createDatabaseAndTables() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("CREATE DATABASE IF NOT EXISTS banco;");
            statement.execute("USE banco;");
            statement.execute("CREATE TABLE IF NOT EXISTS banco (id INT PRIMARY KEY AUTO_INCREMENT, jogador VARCHAR(50) UNIQUE, saldo DECIMAL(10,2) DEFAULT 500, divida DECIMAL(10,2) DEFAULT 0, investimento DECIMAL(10,2) DEFAULT 0);");
            statement.execute("CREATE TABLE IF NOT EXISTS jogadores (id INT AUTO_INCREMENT PRIMARY KEY, nome VARCHAR(50) UNIQUE NOT NULL);");
            statement.execute("CREATE TABLE IF NOT EXISTS carteiras (id INT AUTO_INCREMENT PRIMARY KEY, jogador_id INT NOT NULL, endereco VARCHAR(100) UNIQUE NOT NULL, chave_privada TEXT NOT NULL, frase_secreta TEXT NOT NULL, FOREIGN KEY (jogador_id) REFERENCES jogadores(id) ON DELETE CASCADE);");
            statement.execute("CREATE TABLE IF NOT EXISTS livro_caixa (id INT AUTO_INCREMENT PRIMARY KEY, jogador VARCHAR(255) NOT NULL, tipo_transacao VARCHAR(255) NOT NULL, valor FLOAT NOT NULL, moeda VARCHAR(10) NOT NULL, assinatura VARCHAR(255) NOT NULL, data_hora DATETIME DEFAULT CURRENT_TIMESTAMP);");
            this.getLogger().info("\u2705 Banco de dados e tabelas criados/verificados!");
        }
        catch (SQLException e) {
            this.getLogger().severe("Erro ao criar banco de dados/tabelas: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

